/*
 * Copyright 2002-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.xml.config;

import org.w3c.dom.Element;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractTransformerParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/**
 * @author Jonas Partner
 * @author Mark Fisher
 */
public class MarshallingTransformerParser extends AbstractTransformerParser {

	@Override
	protected String getTransformerClassName() {
		return "org.springframework.integration.xml.transformer.MarshallingTransformer";
	}

	@Override
	protected void parseTransformer(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
		String resultTransformer = element.getAttribute("result-transformer");
		IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "result-type", "resultType");
		IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "result-factory", "resultFactoryName");
		String marshaller = element.getAttribute("marshaller");
		Assert.hasText(marshaller, "the 'marshaller' attribute is required");
		builder.addConstructorArgReference(marshaller);
		if (StringUtils.hasText(resultTransformer)) {
			builder.addConstructorArgReference(resultTransformer);
		}
		String extractPayload = element.getAttribute("extract-payload");
		if (StringUtils.hasText(extractPayload)) {
			builder.addPropertyValue("extractPayload", extractPayload);
		}
	}

}
