/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.core;

import org.jivesoftware.smack.XMPPConnection;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.util.Assert;

public abstract class AbstractXmppConnectionAwareEndpoint
extends MessageProducerSupport {
    protected volatile XMPPConnection xmppConnection;
    protected volatile boolean initialized;

    public AbstractXmppConnectionAwareEndpoint() {
    }

    public AbstractXmppConnectionAwareEndpoint(XMPPConnection xmppConnection) {
        Assert.notNull((Object)xmppConnection, (String)"'xmppConnection' must no be null");
        this.xmppConnection = xmppConnection;
    }

    @Deprecated
    public void setRequestChannel(MessageChannel requestChannel) {
        this.setOutputChannel(requestChannel);
    }

    protected void onInit() {
        super.onInit();
        BeanFactory beanFactory = this.getBeanFactory();
        if (this.xmppConnection == null && beanFactory != null) {
            this.xmppConnection = (XMPPConnection)beanFactory.getBean("xmppConnection", XMPPConnection.class);
        }
        Assert.notNull((Object)this.xmppConnection, (String)"Failed to resolve XMPPConnection. XMPPConnection must either be set expicitly via the 'xmpp-connection' attribute or implicitly by registering a bean with the name 'xmppConnection' and of type 'org.jivesoftware.smack.XMPPConnection' in the Application Context.");
        this.initialized = true;
    }
}

