/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.config.annotation.web.http.support;

import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.GenericRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.session.data.gemfire.config.annotation.web.http.GemFireHttpSessionConfiguration;
import org.springframework.session.data.gemfire.support.GemFireUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GemFireCacheTypeAwareRegionFactoryBean<K, V>
implements BeanFactoryAware,
FactoryBean<Region<K, V>>,
InitializingBean {
    protected static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = GemFireHttpSessionConfiguration.DEFAULT_CLIENT_REGION_SHORTCUT;
    protected static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = GemFireHttpSessionConfiguration.DEFAULT_SERVER_REGION_SHORTCUT;
    protected static final String DEFAULT_POOL_NAME = "gemfirePool";
    protected static final String DEFAULT_SESSION_REGION_NAME = "ClusteredSpringSessions";
    private BeanFactory beanFactory;
    private ClientRegionShortcut clientRegionShortcut;
    private GemFireCache gemfireCache;
    private Region<K, V> region;
    private RegionAttributes<K, V> regionAttributes;
    private RegionShortcut serverRegionShortcut;
    private String poolName;
    private String regionName;

    public void afterPropertiesSet() throws Exception {
        GemFireCache gemfireCache = this.getGemfireCache();
        this.region = GemFireUtils.isClient(gemfireCache) ? this.newClientRegion(gemfireCache) : this.newServerRegion(gemfireCache);
    }

    protected Region<K, V> newServerRegion(GemFireCache gemfireCache) throws Exception {
        GenericRegionFactoryBean serverRegion = new GenericRegionFactoryBean();
        serverRegion.setAttributes(this.getRegionAttributes());
        serverRegion.setCache(gemfireCache);
        serverRegion.setRegionName(this.getRegionName());
        serverRegion.setShortcut(this.getServerRegionShortcut());
        serverRegion.afterPropertiesSet();
        return serverRegion.getObject();
    }

    protected Region<K, V> newClientRegion(GemFireCache gemfireCache) throws Exception {
        ClientRegionFactoryBean clientRegion = new ClientRegionFactoryBean();
        ClientRegionShortcut shortcut = this.getClientRegionShortcut();
        clientRegion.setAttributes(this.getRegionAttributes());
        clientRegion.setBeanFactory(this.getBeanFactory());
        clientRegion.setCache(gemfireCache);
        clientRegion.setInterests(this.registerInterests(!GemFireUtils.isLocal(shortcut)));
        clientRegion.setPoolName(this.getPoolName());
        clientRegion.setRegionName(this.getRegionName());
        clientRegion.setShortcut(shortcut);
        clientRegion.afterPropertiesSet();
        return clientRegion.getObject();
    }

    protected Interest<K>[] registerInterests(boolean register) {
        Interest[] interestArray;
        if (!register) {
            interestArray = new Interest[]{};
        } else {
            Interest[] interestArray2 = new Interest[1];
            interestArray = interestArray2;
            interestArray2[0] = new Interest((Object)"ALL_KEYS", InterestResultPolicy.KEYS);
        }
        return interestArray;
    }

    public Region<K, V> getObject() throws Exception {
        return this.region;
    }

    public Class<?> getObjectType() {
        return Optional.ofNullable(this.region).map(Object::getClass).orElse(Region.class);
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory is required");
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return Optional.ofNullable(this.beanFactory).orElseThrow(() -> new IllegalStateException("A reference to the BeanFactory was not properly configured"));
    }

    public void setClientRegionShortcut(ClientRegionShortcut clientRegionShortcut) {
        this.clientRegionShortcut = clientRegionShortcut;
    }

    protected ClientRegionShortcut getClientRegionShortcut() {
        return Optional.ofNullable(this.clientRegionShortcut).orElse(DEFAULT_CLIENT_REGION_SHORTCUT);
    }

    public void setGemfireCache(GemFireCache gemfireCache) {
        this.gemfireCache = Optional.ofNullable(gemfireCache).orElseThrow(() -> new IllegalArgumentException("GemFireCache is required"));
    }

    protected GemFireCache getGemfireCache() {
        return Optional.ofNullable(this.gemfireCache).orElseThrow(() -> new IllegalStateException("A reference to the GemFireCache was not properly configured"));
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    protected String getPoolName() {
        return Optional.ofNullable(this.poolName).filter(StringUtils::hasText).orElse(DEFAULT_POOL_NAME);
    }

    public void setRegionAttributes(RegionAttributes<K, V> regionAttributes) {
        this.regionAttributes = regionAttributes;
    }

    protected RegionAttributes<K, V> getRegionAttributes() {
        return this.regionAttributes;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    protected String getRegionName() {
        return Optional.ofNullable(this.regionName).filter(StringUtils::hasText).orElse(DEFAULT_SESSION_REGION_NAME);
    }

    public void setServerRegionShortcut(RegionShortcut serverRegionShortcut) {
        this.serverRegionShortcut = serverRegionShortcut;
    }

    protected RegionShortcut getServerRegionShortcut() {
        return Optional.ofNullable(this.serverRegionShortcut).orElse(DEFAULT_SERVER_REGION_SHORTCUT);
    }
}

