/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.config.annotation.web.http.support;

import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.query.Index;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.IndexFactoryBean;
import org.springframework.session.data.gemfire.support.GemFireUtils;
import org.springframework.util.ObjectUtils;

public class SessionAttributesIndexFactoryBean
implements FactoryBean<Index>,
InitializingBean,
BeanFactoryAware,
BeanNameAware {
    protected static final String[] DEFAULT_INDEXABLE_SESSION_ATTRIBUTES = new String[0];
    private BeanFactory beanFactory;
    private GemFireCache gemfireCache;
    private Index sessionAttributesIndex;
    private String beanName;
    private String regionName;
    private String[] indexableSessionAttributes;

    public void afterPropertiesSet() throws Exception {
        if (this.isIndexableSessionAttributesConfigured()) {
            this.sessionAttributesIndex = this.newIndex();
        }
    }

    protected boolean isIndexableSessionAttributesConfigured() {
        return !ObjectUtils.isEmpty((Object[])this.indexableSessionAttributes);
    }

    protected Index newIndex() throws Exception {
        IndexFactoryBean indexFactory = new IndexFactoryBean();
        indexFactory.setBeanFactory(this.beanFactory);
        indexFactory.setBeanName(this.beanName);
        indexFactory.setCache((RegionService)this.gemfireCache);
        indexFactory.setName("sessionAttributesIndex");
        indexFactory.setExpression(String.format("s.attributes[%1$s]", this.getIndexableSessionAttributesAsGemFireIndexExpression()));
        indexFactory.setFrom(String.format("%1$s s", GemFireUtils.toRegionPath(this.regionName)));
        indexFactory.setOverride(true);
        indexFactory.afterPropertiesSet();
        return indexFactory.getObject();
    }

    protected String getIndexableSessionAttributesAsGemFireIndexExpression() {
        StringBuilder builder = new StringBuilder();
        for (String sessionAttribute : this.getIndexableSessionAttributes()) {
            builder.append(builder.length() > 0 ? ", " : "");
            builder.append(String.format("'%s'", sessionAttribute));
        }
        String indexExpression = builder.toString();
        return indexExpression.isEmpty() ? "*" : indexExpression;
    }

    public Index getObject() throws Exception {
        return this.sessionAttributesIndex;
    }

    public Class<?> getObjectType() {
        return Optional.ofNullable(this.sessionAttributesIndex).map(Object::getClass).orElse(Index.class);
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setGemFireCache(GemFireCache gemfireCache) {
        this.gemfireCache = gemfireCache;
    }

    public void setIndexableSessionAttributes(String[] indexableSessionAttributes) {
        this.indexableSessionAttributes = indexableSessionAttributes;
    }

    protected String[] getIndexableSessionAttributes() {
        return Optional.ofNullable(this.indexableSessionAttributes).orElse(DEFAULT_INDEXABLE_SESSION_ATTRIBUTES);
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    protected String getRegionName() {
        return this.regionName;
    }
}

