/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.support;

import java.io.Closeable;
import java.io.IOException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.internal.cache.GemFireCacheImpl;

public abstract class GemFireUtils {
    public static boolean close(Closeable obj) {
        if (obj != null) {
            try {
                obj.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isClient(GemFireCache gemFireCache) {
        boolean client = gemFireCache instanceof ClientCache;
        return client &= !(gemFireCache instanceof GemFireCacheImpl) || ((GemFireCacheImpl)gemFireCache).isClient();
    }

    public static boolean isPeer(GemFireCache gemFireCache) {
        return gemFireCache instanceof Cache && !GemFireUtils.isClient(gemFireCache);
    }

    public static boolean isLocal(ClientRegionShortcut shortcut) {
        switch (shortcut) {
            case LOCAL: 
            case LOCAL_HEAP_LRU: 
            case LOCAL_OVERFLOW: 
            case LOCAL_PERSISTENT: 
            case LOCAL_PERSISTENT_OVERFLOW: {
                return true;
            }
        }
        return false;
    }

    public static boolean isProxy(ClientRegionShortcut shortcut) {
        switch (shortcut) {
            case PROXY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isProxy(Region<?, ?> region) {
        return DataPolicy.EMPTY.equals(region.getAttributes().getDataPolicy());
    }

    public static boolean isProxy(RegionShortcut shortcut) {
        switch (shortcut) {
            case PARTITION_PROXY: 
            case PARTITION_PROXY_REDUNDANT: 
            case REPLICATE_PROXY: {
                return true;
            }
        }
        return false;
    }

    public static String toRegionPath(String regionName) {
        return String.format("%1$s%2$s", "/", regionName);
    }
}

