/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.MongoSession;

public class JacksonMongoSessionConverter
extends AbstractMongoSessionConverter {
    private static final Log LOG = LogFactory.getLog(JacksonMongoSessionConverter.class);
    private static final String ATTRS_FIELD_NAME = "attrs.";
    private static final String PRINCIPAL_FIELD_NAME = "principal";
    private final ObjectMapper objectMapper = this.buildObjectMapper();

    public JacksonMongoSessionConverter() {
        this(Collections.emptyList());
    }

    public JacksonMongoSessionConverter(Iterable<Module> modules) {
        this.objectMapper.registerModules(modules);
    }

    @Override
    protected Query getQueryForIndex(String indexName, Object indexValue) {
        if (FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Query.query((CriteriaDefinition)Criteria.where((String)PRINCIPAL_FIELD_NAME).is(indexValue));
        }
        return Query.query((CriteriaDefinition)Criteria.where((String)(ATTRS_FIELD_NAME + MongoSession.coverDot(indexName))).is(indexValue));
    }

    private ObjectMapper buildObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new MongoIdNamingStrategy());
        return objectMapper;
    }

    @Override
    protected DBObject convert(MongoSession source) {
        try {
            DBObject dbSession = (DBObject)JSON.parse((String)this.objectMapper.writeValueAsString((Object)source));
            dbSession.put(PRINCIPAL_FIELD_NAME, (Object)this.extractPrincipal(source));
            return dbSession;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot convert MongoExpiringSession", e);
        }
    }

    @Override
    protected MongoSession convert(Document source) {
        String json = JSON.serialize((Object)source);
        try {
            return (MongoSession)this.objectMapper.readValue(json, MongoSession.class);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during Mongo Session deserialization", (Throwable)e);
            return null;
        }
    }

    private static class MongoIdNamingStrategy
    extends PropertyNamingStrategy.PropertyNamingStrategyBase {
        private MongoIdNamingStrategy() {
        }

        public String translate(String propertyName) {
            if (propertyName.equals("id")) {
                return "_id";
            }
            if (propertyName.equals("_id")) {
                return "id";
            }
            return propertyName;
        }
    }
}

