/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo.config.annotation.web.http;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.session.IndexResolver;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.SessionIdGenerationStrategy;
import org.springframework.session.SessionRepository;
import org.springframework.session.UuidSessionIdGenerationStrategy;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.JdkMongoSessionConverter;
import org.springframework.session.data.mongo.MongoIndexedSessionRepository;
import org.springframework.session.data.mongo.config.annotation.web.http.EnableMongoHttpSession;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration(proxyBeanMethods=false)
@Import(value={SpringHttpSessionConfiguration.class})
public class MongoHttpSessionConfiguration
implements BeanClassLoaderAware,
EmbeddedValueResolverAware,
ImportAware {
    private AbstractMongoSessionConverter mongoSessionConverter;
    private Duration maxInactiveInterval = MapSession.DEFAULT_MAX_INACTIVE_INTERVAL;
    private String collectionName;
    private StringValueResolver embeddedValueResolver;
    private List<SessionRepositoryCustomizer<MongoIndexedSessionRepository>> sessionRepositoryCustomizers;
    private ClassLoader classLoader;
    private IndexResolver<Session> indexResolver;
    private SessionIdGenerationStrategy sessionIdGenerationStrategy = UuidSessionIdGenerationStrategy.getInstance();

    @Bean
    public MongoIndexedSessionRepository mongoSessionRepository(MongoOperations mongoOperations) {
        MongoIndexedSessionRepository repository = new MongoIndexedSessionRepository(mongoOperations);
        repository.setDefaultMaxInactiveInterval(this.maxInactiveInterval);
        if (this.mongoSessionConverter != null) {
            repository.setMongoSessionConverter(this.mongoSessionConverter);
            if (this.indexResolver != null) {
                this.mongoSessionConverter.setIndexResolver(this.indexResolver);
            }
        } else {
            JdkMongoSessionConverter mongoSessionConverter = new JdkMongoSessionConverter((Converter<Object, byte[]>)new SerializingConverter(), (Converter<byte[], Object>)new DeserializingConverter(this.classLoader), Duration.ofSeconds(1800L));
            if (this.indexResolver != null) {
                mongoSessionConverter.setIndexResolver(this.indexResolver);
            }
            repository.setMongoSessionConverter(mongoSessionConverter);
        }
        if (StringUtils.hasText((String)this.collectionName)) {
            repository.setCollectionName(this.collectionName);
        }
        repository.setSessionIdGenerationStrategy(this.sessionIdGenerationStrategy);
        this.sessionRepositoryCustomizers.forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((SessionRepository)repository));
        return repository;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    @Deprecated
    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveIntervalInSeconds.intValue()));
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String collectionNameValue;
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableMongoHttpSession.class.getName()));
        if (attributes != null) {
            this.maxInactiveInterval = Duration.ofSeconds(((Integer)attributes.getNumber("maxInactiveIntervalInSeconds")).intValue());
        }
        String string = collectionNameValue = attributes != null ? attributes.getString("collectionName") : "";
        if (StringUtils.hasText((String)collectionNameValue)) {
            this.collectionName = this.embeddedValueResolver.resolveStringValue(collectionNameValue);
        }
    }

    @Autowired(required=false)
    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }

    @Autowired(required=false)
    public void setSessionRepositoryCustomizers(ObjectProvider<SessionRepositoryCustomizer<MongoIndexedSessionRepository>> sessionRepositoryCustomizers) {
        this.sessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Autowired(required=false)
    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        this.indexResolver = indexResolver;
    }

    @Autowired(required=false)
    public void setSessionIdGenerationStrategy(SessionIdGenerationStrategy sessionIdGenerationStrategy) {
        this.sessionIdGenerationStrategy = sessionIdGenerationStrategy;
    }
}

