/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo.config.annotation.web.reactive;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.session.IndexResolver;
import org.springframework.session.MapSession;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionIdGenerationStrategy;
import org.springframework.session.UuidSessionIdGenerationStrategy;
import org.springframework.session.config.ReactiveSessionRepositoryCustomizer;
import org.springframework.session.config.annotation.web.server.SpringWebSessionConfiguration;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.JdkMongoSessionConverter;
import org.springframework.session.data.mongo.ReactiveMongoSessionRepository;
import org.springframework.session.data.mongo.config.annotation.web.reactive.EnableMongoWebSession;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration(proxyBeanMethods=false)
@Import(value={SpringWebSessionConfiguration.class})
public class ReactiveMongoWebSessionConfiguration
implements BeanClassLoaderAware,
EmbeddedValueResolverAware,
ImportAware {
    private AbstractMongoSessionConverter mongoSessionConverter;
    private Duration maxInactiveInterval = MapSession.DEFAULT_MAX_INACTIVE_INTERVAL;
    private String collectionName;
    private StringValueResolver embeddedValueResolver;
    private List<ReactiveSessionRepositoryCustomizer<ReactiveMongoSessionRepository>> sessionRepositoryCustomizers;
    @Autowired(required=false)
    private MongoOperations mongoOperations;
    private ClassLoader classLoader;
    private IndexResolver<Session> indexResolver;
    private SessionIdGenerationStrategy sessionIdGenerationStrategy = UuidSessionIdGenerationStrategy.getInstance();

    @Bean
    public ReactiveMongoSessionRepository reactiveMongoSessionRepository(ReactiveMongoOperations operations) {
        ReactiveMongoSessionRepository repository = new ReactiveMongoSessionRepository(operations);
        if (this.mongoSessionConverter != null) {
            repository.setMongoSessionConverter(this.mongoSessionConverter);
            if (this.indexResolver != null) {
                this.mongoSessionConverter.setIndexResolver(this.indexResolver);
            }
        } else {
            JdkMongoSessionConverter mongoSessionConverter = new JdkMongoSessionConverter((Converter<Object, byte[]>)new SerializingConverter(), (Converter<byte[], Object>)new DeserializingConverter(this.classLoader), Duration.ofSeconds(1800L));
            if (this.indexResolver != null) {
                mongoSessionConverter.setIndexResolver(this.indexResolver);
            }
            repository.setMongoSessionConverter(mongoSessionConverter);
        }
        repository.setDefaultMaxInactiveInterval(this.maxInactiveInterval);
        if (this.collectionName != null) {
            repository.setCollectionName(this.collectionName);
        }
        if (this.mongoOperations != null) {
            repository.setBlockingMongoOperations(this.mongoOperations);
        }
        this.sessionRepositoryCustomizers.forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((ReactiveSessionRepository)repository));
        repository.setSessionIdGenerationStrategy(this.sessionIdGenerationStrategy);
        return repository;
    }

    @Autowired(required=false)
    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String collectionNameValue;
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableMongoWebSession.class.getName()));
        if (attributes != null) {
            this.maxInactiveInterval = Duration.ofSeconds(((Integer)attributes.getNumber("maxInactiveIntervalInSeconds")).intValue());
        }
        String string = collectionNameValue = attributes != null ? attributes.getString("collectionName") : "";
        if (StringUtils.hasText((String)collectionNameValue)) {
            this.collectionName = this.embeddedValueResolver.resolveStringValue(collectionNameValue);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEmbeddedValueResolver(StringValueResolver embeddedValueResolver) {
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public Duration getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    @Deprecated
    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveIntervalInSeconds.intValue()));
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @Autowired(required=false)
    public void setSessionRepositoryCustomizers(ObjectProvider<ReactiveSessionRepositoryCustomizer<ReactiveMongoSessionRepository>> sessionRepositoryCustomizers) {
        this.sessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    @Autowired(required=false)
    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        this.indexResolver = indexResolver;
    }

    @Autowired(required=false)
    public void setSessionIdGenerationStrategy(SessionIdGenerationStrategy sessionIdGenerationStrategy) {
        this.sessionIdGenerationStrategy = sessionIdGenerationStrategy;
    }
}

