/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config.annotation.web.reactor;

import java.util.Map;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.session.SpringWebSessionConfiguration;
import org.springframework.session.data.redis.ReactiveRedisOperationsSessionRepository;
import org.springframework.session.data.redis.RedisFlushMode;
import org.springframework.session.data.redis.config.annotation.web.reactor.EnableRedisReactorSession;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration
public class RedisReactorSessionConfiguration
extends SpringWebSessionConfiguration
implements EmbeddedValueResolverAware,
ImportAware {
    private static final RedisSerializer<String> keySerializer = new StringRedisSerializer();
    private static final RedisSerializer<Object> valueSerializer = new JdkSerializationRedisSerializer();
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String redisNamespace = "";
    private RedisFlushMode redisFlushMode = RedisFlushMode.ON_SAVE;
    private StringValueResolver embeddedValueResolver;

    @Bean
    public ReactiveRedisOperationsSessionRepository sessionRepository(ReactiveRedisConnectionFactory redisConnectionFactory) {
        ReactiveRedisOperationsSessionRepository sessionRepository = new ReactiveRedisOperationsSessionRepository((ReactiveRedisOperations<String, Object>)RedisReactorSessionConfiguration.createDefaultTemplate(redisConnectionFactory));
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        String redisNamespace = this.getRedisNamespace();
        if (StringUtils.hasText((String)redisNamespace)) {
            sessionRepository.setRedisKeyNamespace(redisNamespace);
        }
        sessionRepository.setRedisFlushMode(this.redisFlushMode);
        return sessionRepository;
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setRedisNamespace(String namespace) {
        this.redisNamespace = namespace;
    }

    public void setRedisFlushMode(RedisFlushMode redisFlushMode) {
        Assert.notNull((Object)((Object)redisFlushMode), (String)"redisFlushMode cannot be null");
        this.redisFlushMode = redisFlushMode;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableAttrMap = importMetadata.getAnnotationAttributes(EnableRedisReactorSession.class.getName());
        AnnotationAttributes enableAttrs = AnnotationAttributes.fromMap((Map)enableAttrMap);
        if (enableAttrs != null) {
            this.maxInactiveIntervalInSeconds = (Integer)enableAttrs.getNumber("maxInactiveIntervalInSeconds");
            String redisNamespaceValue = enableAttrs.getString("redisNamespace");
            if (StringUtils.hasText((String)redisNamespaceValue)) {
                this.redisNamespace = this.embeddedValueResolver.resolveStringValue(redisNamespaceValue);
            }
            this.redisFlushMode = (RedisFlushMode)enableAttrs.getEnum("redisFlushMode");
        }
    }

    private static ReactiveRedisTemplate<String, Object> createDefaultTemplate(ReactiveRedisConnectionFactory connectionFactory) {
        RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext(valueSerializer).key(keySerializer).hashKey(keySerializer).build();
        return new ReactiveRedisTemplate(connectionFactory, serializationContext);
    }

    private String getRedisNamespace() {
        if (StringUtils.hasText((String)this.redisNamespace)) {
            return this.redisNamespace;
        }
        return System.getProperty("spring.session.redis.namespace", "");
    }
}

