/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.data.redis.RedisFlushMode;
import org.springframework.session.data.redis.RedisSessionMapper;
import org.springframework.util.Assert;

public class SimpleRedisOperationsSessionRepository
implements SessionRepository<RedisSession> {
    private static final String DEFAULT_KEY_NAMESPACE = "spring:session:";
    private final RedisOperations<String, Object> sessionRedisOperations;
    private Duration defaultMaxInactiveInterval = Duration.ofSeconds(1800L);
    private String keyNamespace = "spring:session:";
    private RedisFlushMode flushMode = RedisFlushMode.ON_SAVE;

    public SimpleRedisOperationsSessionRepository(RedisOperations<String, Object> sessionRedisOperations) {
        Assert.notNull(sessionRedisOperations, (String)"sessionRedisOperations mut not be null");
        this.sessionRedisOperations = sessionRedisOperations;
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        Assert.notNull((Object)defaultMaxInactiveInterval, (String)"defaultMaxInactiveInterval must not be null");
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setKeyNamespace(String keyNamespace) {
        Assert.hasText((String)keyNamespace, (String)"keyNamespace must not be empty");
        this.keyNamespace = keyNamespace;
    }

    public void setFlushMode(RedisFlushMode flushMode) {
        Assert.notNull((Object)((Object)flushMode), (String)"flushMode must not be null");
        this.flushMode = flushMode;
    }

    public RedisSession createSession() {
        RedisSession session = new RedisSession(this.defaultMaxInactiveInterval);
        session.flushIfRequired();
        return session;
    }

    public void save(RedisSession session) {
        String key;
        Boolean sessionExists;
        if (!(session.isNew || (sessionExists = this.sessionRedisOperations.hasKey((Object)(key = this.getSessionKey(session.hasChangedSessionId() ? session.originalSessionId : session.getId())))) != null && sessionExists.booleanValue())) {
            throw new IllegalStateException("Session was invalidated");
        }
        session.save();
    }

    public RedisSession findById(String sessionId) {
        String key = this.getSessionKey(sessionId);
        Map entries = this.sessionRedisOperations.opsForHash().entries((Object)key);
        if (entries.isEmpty()) {
            return null;
        }
        MapSession session = new RedisSessionMapper(sessionId).apply(entries);
        if (session.isExpired()) {
            this.deleteById(sessionId);
            return null;
        }
        return new RedisSession(session);
    }

    public void deleteById(String sessionId) {
        String key = this.getSessionKey(sessionId);
        this.sessionRedisOperations.delete((Object)key);
    }

    public RedisOperations<String, Object> getSessionRedisOperations() {
        return this.sessionRedisOperations;
    }

    private String getSessionKey(String sessionId) {
        return this.keyNamespace + "sessions:" + sessionId;
    }

    final class RedisSession
    implements Session {
        private final MapSession cached;
        private final Map<String, Object> delta = new HashMap<String, Object>();
        private boolean isNew;
        private String originalSessionId;

        RedisSession(Duration maxInactiveInterval) {
            this(new MapSession());
            this.cached.setMaxInactiveInterval(maxInactiveInterval);
            this.delta.put("creationTime", this.getCreationTime().toEpochMilli());
            this.delta.put("maxInactiveInterval", (int)this.getMaxInactiveInterval().getSeconds());
            this.delta.put("lastAccessedTime", this.getLastAccessedTime().toEpochMilli());
            this.isNew = true;
        }

        RedisSession(MapSession cached) {
            this.cached = cached;
            this.originalSessionId = cached.getId();
        }

        public String getId() {
            return this.cached.getId();
        }

        public String changeSessionId() {
            return this.cached.changeSessionId();
        }

        public <T> T getAttribute(String attributeName) {
            return (T)this.cached.getAttribute(attributeName);
        }

        public Set<String> getAttributeNames() {
            return this.cached.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            this.cached.setAttribute(attributeName, attributeValue);
            this.putAttribute("sessionAttr:" + attributeName, attributeValue);
        }

        public void removeAttribute(String attributeName) {
            this.setAttribute(attributeName, null);
        }

        public Instant getCreationTime() {
            return this.cached.getCreationTime();
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.cached.setLastAccessedTime(lastAccessedTime);
            this.putAttribute("lastAccessedTime", this.getLastAccessedTime().toEpochMilli());
        }

        public Instant getLastAccessedTime() {
            return this.cached.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.cached.setMaxInactiveInterval(interval);
            this.putAttribute("maxInactiveInterval", (int)this.getMaxInactiveInterval().getSeconds());
        }

        public Duration getMaxInactiveInterval() {
            return this.cached.getMaxInactiveInterval();
        }

        public boolean isExpired() {
            return this.cached.isExpired();
        }

        private void flushIfRequired() {
            if (SimpleRedisOperationsSessionRepository.this.flushMode == RedisFlushMode.IMMEDIATE) {
                this.save();
            }
        }

        private boolean hasChangedSessionId() {
            return !this.getId().equals(this.originalSessionId);
        }

        private void save() {
            this.saveChangeSessionId();
            this.saveDelta();
            if (this.isNew) {
                this.isNew = false;
            }
        }

        private void saveChangeSessionId() {
            if (this.hasChangedSessionId()) {
                if (!this.isNew) {
                    String originalSessionIdKey = SimpleRedisOperationsSessionRepository.this.getSessionKey(this.originalSessionId);
                    String sessionIdKey = SimpleRedisOperationsSessionRepository.this.getSessionKey(this.getId());
                    SimpleRedisOperationsSessionRepository.this.sessionRedisOperations.rename((Object)originalSessionIdKey, (Object)sessionIdKey);
                }
                this.originalSessionId = this.getId();
            }
        }

        private void saveDelta() {
            if (this.delta.isEmpty()) {
                return;
            }
            String key = SimpleRedisOperationsSessionRepository.this.getSessionKey(this.getId());
            SimpleRedisOperationsSessionRepository.this.sessionRedisOperations.opsForHash().putAll((Object)key, new HashMap<String, Object>(this.delta));
            SimpleRedisOperationsSessionRepository.this.sessionRedisOperations.expireAt((Object)key, Date.from(Instant.ofEpochMilli(this.getLastAccessedTime().toEpochMilli()).plusSeconds(this.getMaxInactiveInterval().getSeconds())));
            this.delta.clear();
        }

        private void putAttribute(String name, Object value) {
            this.delta.put(name, value);
            this.flushIfRequired();
        }
    }
}

