/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.Ordered;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.portlet.HandlerExecutionChain;
import org.springframework.web.portlet.HandlerInterceptor;
import org.springframework.web.portlet.HandlerMapping;
import org.springframework.web.portlet.handler.WebRequestHandlerInterceptorAdapter;

public abstract class AbstractHandlerMapping
extends ApplicationObjectSupport
implements HandlerMapping,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Object defaultHandler;
    private final List<Object> interceptors = new ArrayList<Object>();
    private boolean applyWebRequestInterceptorsToRenderPhaseOnly = true;
    private HandlerInterceptor[] adaptedInterceptors;

    public final void setOrder(int order) {
        this.order = order;
    }

    public final int getOrder() {
        return this.order;
    }

    public void setDefaultHandler(Object defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public Object getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setInterceptors(Object[] interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
    }

    public void setApplyWebRequestInterceptorsToRenderPhaseOnly(boolean applyWebRequestInterceptorsToRenderPhaseOnly) {
        this.applyWebRequestInterceptorsToRenderPhaseOnly = applyWebRequestInterceptorsToRenderPhaseOnly;
    }

    protected void initApplicationContext() throws BeansException {
        this.extendInterceptors(this.interceptors);
        this.initInterceptors();
    }

    protected void extendInterceptors(List interceptors) {
    }

    protected void initInterceptors() {
        if (!this.interceptors.isEmpty()) {
            this.adaptedInterceptors = new HandlerInterceptor[this.interceptors.size()];
            for (int i = 0; i < this.interceptors.size(); ++i) {
                Object interceptor = this.interceptors.get(i);
                if (interceptor == null) {
                    throw new IllegalArgumentException("Entry number " + i + " in interceptors array is null");
                }
                this.adaptedInterceptors[i] = this.adaptInterceptor(interceptor);
            }
        }
    }

    protected HandlerInterceptor adaptInterceptor(Object interceptor) {
        if (interceptor instanceof HandlerInterceptor) {
            return (HandlerInterceptor)interceptor;
        }
        if (interceptor instanceof WebRequestInterceptor) {
            return new WebRequestHandlerInterceptorAdapter((WebRequestInterceptor)interceptor, this.applyWebRequestInterceptorsToRenderPhaseOnly);
        }
        throw new IllegalArgumentException("Interceptor type not supported: " + interceptor.getClass().getName());
    }

    protected final HandlerInterceptor[] getAdaptedInterceptors() {
        return this.adaptedInterceptors;
    }

    @Override
    public final HandlerExecutionChain getHandler(PortletRequest request) throws Exception {
        Object handler = this.getHandlerInternal(request);
        if (handler == null) {
            handler = this.getDefaultHandler();
        }
        if (handler == null) {
            return null;
        }
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.getApplicationContext().getBean(handlerName);
        }
        return this.getHandlerExecutionChain(handler, request);
    }

    protected abstract Object getHandlerInternal(PortletRequest var1) throws Exception;

    protected HandlerExecutionChain getHandlerExecutionChain(Object handler, PortletRequest request) {
        if (handler instanceof HandlerExecutionChain) {
            HandlerExecutionChain chain = (HandlerExecutionChain)handler;
            chain.addInterceptors(this.getAdaptedInterceptors());
            return chain;
        }
        return new HandlerExecutionChain(handler, this.getAdaptedInterceptors());
    }
}

