/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodArgumentResolver;

public abstract class AbstractMessageConverterMethodProcessor
extends AbstractMessageConverterMethodArgumentResolver
implements HandlerMethodReturnValueHandler {
    private static final MediaType MEDIA_TYPE_APPLICATION = new MediaType("application");
    private final ContentNegotiationManager contentNegotiationManager;

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters) {
        this(converters, (ContentNegotiationManager)null);
    }

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters, ContentNegotiationManager contentNegotiationManager) {
        this(converters, contentNegotiationManager, null);
    }

    protected AbstractMessageConverterMethodProcessor(List<HttpMessageConverter<?>> converters, ContentNegotiationManager manager, List<Object> requestResponseBodyAdvice) {
        super(converters, requestResponseBodyAdvice);
        this.contentNegotiationManager = manager != null ? manager : new ContentNegotiationManager();
    }

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        return new ServletServerHttpResponse(response);
    }

    protected <T> void writeWithMessageConverters(T returnValue, MethodParameter returnType, NativeWebRequest webRequest) throws IOException, HttpMediaTypeNotAcceptableException {
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        this.writeWithMessageConverters(returnValue, returnType, inputMessage, outputMessage);
    }

    protected <T> void writeWithMessageConverters(T returnValue, MethodParameter returnType, ServletServerHttpRequest inputMessage, ServletServerHttpResponse outputMessage) throws IOException, HttpMediaTypeNotAcceptableException {
        Class<?> returnValueClass = this.getReturnValueType(returnValue, returnType);
        Type returnValueType = this.getGenericType(returnType);
        HttpServletRequest servletRequest = inputMessage.getServletRequest();
        List<MediaType> requestedMediaTypes = this.getAcceptableMediaTypes(servletRequest);
        List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(servletRequest, returnValueClass, returnValueType);
        Assert.isTrue((returnValue == null || !producibleMediaTypes.isEmpty() ? 1 : 0) != 0, (String)("No converter found for return value of type: " + returnValueClass));
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType requestedType : requestedMediaTypes) {
            for (MediaType producibleType : producibleMediaTypes) {
                if (!requestedType.isCompatibleWith(producibleType)) continue;
                compatibleMediaTypes.add(this.getMostSpecificMediaType(requestedType, producibleType));
            }
        }
        if (compatibleMediaTypes.isEmpty()) {
            if (returnValue != null) {
                throw new HttpMediaTypeNotAcceptableException(producibleMediaTypes);
            }
            return;
        }
        ArrayList mediaTypes = new ArrayList(compatibleMediaTypes);
        MediaType.sortBySpecificityAndQuality(mediaTypes);
        MediaType selectedMediaType = null;
        for (MediaType mediaType : mediaTypes) {
            if (mediaType.isConcrete()) {
                selectedMediaType = mediaType;
                break;
            }
            if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION)) continue;
            selectedMediaType = MediaType.APPLICATION_OCTET_STREAM;
            break;
        }
        if (selectedMediaType != null) {
            selectedMediaType = selectedMediaType.removeQualityValue();
            for (HttpMessageConverter messageConverter : this.messageConverters) {
                if (messageConverter instanceof GenericHttpMessageConverter) {
                    if (!((GenericHttpMessageConverter)messageConverter).canWrite(returnValueType, returnValueClass, selectedMediaType)) continue;
                    returnValue = this.getAdvice().beforeBodyWrite(returnValue, returnType, selectedMediaType, (Class<? extends HttpMessageConverter<?>>)messageConverter.getClass(), (ServerHttpRequest)inputMessage, (ServerHttpResponse)outputMessage);
                    if (returnValue != null) {
                        ((GenericHttpMessageConverter)messageConverter).write(returnValue, returnValueType, selectedMediaType, (HttpOutputMessage)outputMessage);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Written [" + returnValue + "] as \"" + selectedMediaType + "\" using [" + messageConverter + "]"));
                        }
                    }
                    return;
                }
                if (!messageConverter.canWrite(returnValueClass, selectedMediaType)) continue;
                returnValue = this.getAdvice().beforeBodyWrite(returnValue, returnType, selectedMediaType, (Class<? extends HttpMessageConverter<?>>)messageConverter.getClass(), (ServerHttpRequest)inputMessage, (ServerHttpResponse)outputMessage);
                if (returnValue != null) {
                    messageConverter.write(returnValue, selectedMediaType, (HttpOutputMessage)outputMessage);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Written [" + returnValue + "] as \"" + selectedMediaType + "\" using [" + messageConverter + "]"));
                    }
                }
                return;
            }
        }
        if (returnValue != null) {
            throw new HttpMediaTypeNotAcceptableException(this.allSupportedMediaTypes);
        }
    }

    protected Class<?> getReturnValueType(Object returnValue, MethodParameter returnType) {
        return returnValue != null ? returnValue.getClass() : returnType.getParameterType();
    }

    private Type getGenericType(MethodParameter returnType) {
        Type type;
        if (HttpEntity.class.isAssignableFrom(returnType.getParameterType())) {
            returnType.increaseNestingLevel();
            type = returnType.getNestedGenericParameterType();
        } else {
            type = returnType.getGenericParameterType();
        }
        return type;
    }

    protected List<MediaType> getProducibleMediaTypes(HttpServletRequest request, Class<?> returnValueClass) {
        return this.getProducibleMediaTypes(request, returnValueClass, null);
    }

    protected List<MediaType> getProducibleMediaTypes(HttpServletRequest request, Class<?> returnValueClass, Type returnValueType) {
        Set mediaTypes = (Set)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            return new ArrayList<MediaType>(mediaTypes);
        }
        if (!this.allSupportedMediaTypes.isEmpty()) {
            ArrayList<MediaType> result = new ArrayList<MediaType>();
            for (HttpMessageConverter converter : this.messageConverters) {
                if (converter instanceof GenericHttpMessageConverter && returnValueType != null) {
                    if (!((GenericHttpMessageConverter)converter).canWrite(returnValueType, returnValueClass, null)) continue;
                    result.addAll(converter.getSupportedMediaTypes());
                    continue;
                }
                if (!converter.canWrite(returnValueClass, null)) continue;
                result.addAll(converter.getSupportedMediaTypes());
            }
            return result;
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private List<MediaType> getAcceptableMediaTypes(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
        List<MediaType> mediaTypes = this.contentNegotiationManager.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(request));
        return mediaTypes.isEmpty() ? Collections.singletonList(MediaType.ALL) : mediaTypes;
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        MediaType produceTypeToUse = produceType.copyQualityValue(acceptType);
        return MediaType.SPECIFICITY_COMPARATOR.compare(acceptType, produceTypeToUse) <= 0 ? acceptType : produceTypeToUse;
    }
}

