/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;

public class ResponseBodyEmitterReturnValueHandler
implements AsyncHandlerMethodReturnValueHandler {
    private static final Log logger = LogFactory.getLog(ResponseBodyEmitterReturnValueHandler.class);
    private final List<HttpMessageConverter<?>> messageConverters;

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"'messageConverters' must not be empty");
        this.messageConverters = messageConverters;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        if (ResponseBodyEmitter.class.isAssignableFrom(returnType.getParameterType())) {
            return true;
        }
        if (ResponseEntity.class.isAssignableFrom(returnType.getParameterType())) {
            Class bodyType = ResolvableType.forMethodParameter((MethodParameter)returnType).getGeneric(new int[]{0}).resolve();
            return bodyType != null && ResponseBodyEmitter.class.isAssignableFrom(bodyType);
        }
        return false;
    }

    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        if (returnValue != null) {
            if (returnValue instanceof ResponseBodyEmitter) {
                return true;
            }
            if (returnValue instanceof ResponseEntity) {
                Object body = ((ResponseEntity)returnValue).getBody();
                return body != null && body instanceof ResponseBodyEmitter;
            }
        }
        return false;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        Object outputMessage = new ServletServerHttpResponse(response);
        if (ResponseEntity.class.isAssignableFrom(returnValue.getClass())) {
            ResponseEntity responseEntity = (ResponseEntity)returnValue;
            outputMessage.setStatusCode(responseEntity.getStatusCode());
            outputMessage.getHeaders().putAll((Map)responseEntity.getHeaders());
            returnValue = responseEntity.getBody();
            if (returnValue == null) {
                mavContainer.setRequestHandled(true);
                return;
            }
        }
        ServletRequest request = (ServletRequest)webRequest.getNativeRequest(ServletRequest.class);
        ShallowEtagHeaderFilter.disableContentCaching((ServletRequest)request);
        Assert.isInstanceOf(ResponseBodyEmitter.class, (Object)returnValue);
        ResponseBodyEmitter emitter = (ResponseBodyEmitter)returnValue;
        emitter.extendResponse((ServerHttpResponse)outputMessage);
        outputMessage.getBody();
        outputMessage = new StreamingServletServerHttpResponse((ServerHttpResponse)outputMessage);
        DeferredResult deferredResult = new DeferredResult(emitter.getTimeout());
        WebAsyncUtils.getAsyncManager((WebRequest)webRequest).startDeferredResultProcessing(deferredResult, new Object[]{mavContainer});
        HttpMessageConvertingHandler handler = new HttpMessageConvertingHandler((ServerHttpResponse)outputMessage, deferredResult);
        emitter.initialize(handler);
    }

    private static class StreamingServletServerHttpResponse
    implements ServerHttpResponse {
        private final ServerHttpResponse delegate;
        private final HttpHeaders mutableHeaders = new HttpHeaders();

        public StreamingServletServerHttpResponse(ServerHttpResponse delegate) {
            this.delegate = delegate;
            this.mutableHeaders.putAll((Map)delegate.getHeaders());
        }

        public void setStatusCode(HttpStatus status) {
            this.delegate.setStatusCode(status);
        }

        public HttpHeaders getHeaders() {
            return this.mutableHeaders;
        }

        public OutputStream getBody() throws IOException {
            return this.delegate.getBody();
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() {
            this.delegate.close();
        }
    }

    private class HttpMessageConvertingHandler
    implements ResponseBodyEmitter.Handler {
        private final ServerHttpResponse outputMessage;
        private final DeferredResult<?> deferredResult;

        public HttpMessageConvertingHandler(ServerHttpResponse outputMessage, DeferredResult<?> deferredResult) {
            this.outputMessage = outputMessage;
            this.deferredResult = deferredResult;
        }

        @Override
        public void send(Object data, MediaType mediaType) throws IOException {
            this.sendInternal(data, mediaType);
        }

        private <T> void sendInternal(T data, MediaType mediaType) throws IOException {
            for (HttpMessageConverter converter : ResponseBodyEmitterReturnValueHandler.this.messageConverters) {
                if (!converter.canWrite(data.getClass(), mediaType)) continue;
                converter.write(data, mediaType, (HttpOutputMessage)this.outputMessage);
                this.outputMessage.flush();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Written [" + data + "] using [" + converter + "]"));
                }
                return;
            }
            throw new IllegalArgumentException("No suitable converter for " + data.getClass());
        }

        @Override
        public void complete() {
            this.deferredResult.setResult(null);
        }

        @Override
        public void completeWithError(Throwable failure) {
            this.deferredResult.setErrorResult((Object)failure);
        }

        @Override
        public void onTimeout(Runnable callback) {
            this.deferredResult.onTimeout(callback);
        }

        @Override
        public void onCompletion(Runnable callback) {
            this.deferredResult.onCompletion(callback);
        }
    }
}

