/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.GzipResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.ResourceTransformerSupport;
import org.springframework.web.servlet.resource.TransformedResource;

public class CssLinkResourceTransformer
extends ResourceTransformerSupport {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Log logger = LogFactory.getLog(CssLinkResourceTransformer.class);
    private final List<LinkParser> linkParsers = new ArrayList<LinkParser>(2);

    public CssLinkResourceTransformer() {
        this.linkParsers.add(new ImportStatementLinkParser());
        this.linkParsers.add(new UrlFunctionLinkParser());
    }

    @Override
    public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        String filename = (resource = transformerChain.transform(request, resource)).getFilename();
        if (!"css".equals(StringUtils.getFilenameExtension((String)filename)) || resource instanceof GzipResourceResolver.GzippedResource) {
            return resource;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Transforming resource: " + resource));
        }
        byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
        String content = new String(bytes, DEFAULT_CHARSET);
        ArrayList<Segment> linkSegments = new ArrayList<Segment>(8);
        for (LinkParser parser : this.linkParsers) {
            linkSegments.addAll(parser.parseLink(content));
        }
        if (linkSegments.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"No links found.");
            }
            return resource;
        }
        Collections.sort(linkSegments);
        int index = 0;
        StringWriter writer = new StringWriter();
        for (Segment linkSegment : linkSegments) {
            writer.write(content.substring(index, linkSegment.getStart()));
            String link = content.substring(linkSegment.getStart(), linkSegment.getEnd());
            String newLink = null;
            if (!this.hasScheme(link)) {
                String absolutePath = this.toAbsolutePath(link, request);
                newLink = this.resolveUrlPath(absolutePath, request, resource, transformerChain);
            }
            if (logger.isTraceEnabled()) {
                if (newLink != null && !newLink.equals(link)) {
                    logger.trace((Object)("Link modified: " + newLink + " (original: " + link + ")"));
                } else {
                    logger.trace((Object)("Link not modified: " + link));
                }
            }
            writer.write(newLink != null ? newLink : link);
            index = linkSegment.getEnd();
        }
        writer.write(content.substring(index));
        return new TransformedResource(resource, writer.toString().getBytes(DEFAULT_CHARSET));
    }

    private boolean hasScheme(String link) {
        int schemeIndex = link.indexOf(":");
        return schemeIndex > 0 && !link.substring(0, schemeIndex).contains("/") || link.indexOf("//") == 0;
    }

    private static class Segment
    implements Comparable<Segment> {
        private final int start;
        private final int end;

        public Segment(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @Override
        public int compareTo(Segment other) {
            return this.start < other.start ? -1 : (this.start == other.start ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Segment) {
                Segment other = (Segment)obj;
                return this.start == other.start && this.end == other.end;
            }
            return false;
        }

        public int hashCode() {
            return this.start * 31 + this.end;
        }
    }

    private static class UrlFunctionLinkParser
    extends AbstractLinkParser {
        private UrlFunctionLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "url(";
        }

        @Override
        protected int extractLink(int index, String content, Set<Segment> linksToAdd) {
            return this.addLink(index - 1, ")", content, linksToAdd);
        }
    }

    private static class ImportStatementLinkParser
    extends AbstractLinkParser {
        private ImportStatementLinkParser() {
        }

        @Override
        protected String getKeyword() {
            return "@import";
        }

        @Override
        protected int extractLink(int index, String content, Set<Segment> linksToAdd) {
            if (!content.substring(index, index + 4).equals("url(") && logger.isErrorEnabled()) {
                logger.error((Object)("Unexpected syntax for @import link at index " + index));
            }
            return index;
        }
    }

    protected static abstract class AbstractLinkParser
    implements LinkParser {
        protected AbstractLinkParser() {
        }

        protected abstract String getKeyword();

        @Override
        public Set<Segment> parseLink(String content) {
            HashSet<Segment> linksToAdd = new HashSet<Segment>(8);
            int index = 0;
            while ((index = content.indexOf(this.getKeyword(), index)) != -1) {
                if (content.charAt(index = this.skipWhitespace(content, index + this.getKeyword().length())) == '\'') {
                    index = this.addLink(index, "'", content, linksToAdd);
                    continue;
                }
                if (content.charAt(index) == '\"') {
                    index = this.addLink(index, "\"", content, linksToAdd);
                    continue;
                }
                index = this.extractLink(index, content, linksToAdd);
            }
            return linksToAdd;
        }

        private int skipWhitespace(String content, int index) {
            while (Character.isWhitespace(content.charAt(index))) {
                ++index;
            }
            return index;
        }

        protected int addLink(int index, String endKey, String content, Set<Segment> linksToAdd) {
            int start = index + 1;
            int end = content.indexOf(endKey, start);
            linksToAdd.add(new Segment(start, end));
            return end + endKey.length();
        }

        protected abstract int extractLink(int var1, String var2, Set<Segment> var3);
    }

    @FunctionalInterface
    protected static interface LinkParser {
        public Set<Segment> parseLink(String var1);
    }
}

