/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.xd.integration.hadoop.config;

import org.w3c.dom.Element;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;

/**
 * Utility class to creates a {@link BeanDefinitionBuilder} for {@link HdfsStoreMessageHandlerFactoryBean}.
 *
 * @author Janne Valkealahti
 */
abstract class HdfsStoreMessageHandlerBeanDefinitionBuilder {

	/**
	 * Builds and configures a {@link BeanDefinitionBuilder} for {@link HdfsStoreMessageHandlerFactoryBean}.
	 *
	 * @param element The element.
	 * @param parserContext The parser context.
	 * @return The bean definition builder
	 */
	static BeanDefinitionBuilder configure(Element element, ParserContext parserContext) {
		BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HdfsStoreMessageHandlerFactoryBean.class);
		IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, "writer", "storeWriter");
		IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "auto-startup");
		return builder;
	}

}
