/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.event;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.integration.adapter.AbstractSourceAdapter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationEventSourceAdapter
extends AbstractSourceAdapter<ApplicationEvent>
implements ApplicationListener {
    private List<Class<? extends ApplicationEvent>> eventTypes = new ArrayList<Class<? extends ApplicationEvent>>();

    public void setEventTypes(List<Class<? extends ApplicationEvent>> eventTypes) {
        Assert.notEmpty(eventTypes, (String)"at least one event type is required");
        this.eventTypes = eventTypes;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (CollectionUtils.isEmpty(this.eventTypes)) {
            this.sendToChannel(event);
            return;
        }
        for (Class<? extends ApplicationEvent> eventType : this.eventTypes) {
            if (!eventType.isAssignableFrom(event.getClass())) continue;
            this.sendToChannel(event);
            return;
        }
    }
}

