/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.file;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.adapter.file.DefaultFileNameGenerator;
import org.springframework.integration.adapter.file.FileNameGenerator;
import org.springframework.integration.message.AbstractMessageMapper;
import org.springframework.integration.message.GenericMessage;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileMapper<T>
extends AbstractMessageMapper<T, File> {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private File parentDirectory;
    private File backupDirectory;
    private FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();

    public AbstractFileMapper(File parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public void setBackupDirectory(File backupDirectory) {
        this.backupDirectory = backupDirectory;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Assert.notNull((Object)fileNameGenerator, (String)"'fileNameGenerator' must not be null");
        this.fileNameGenerator = fileNameGenerator;
    }

    public File fromMessage(Message<T> message) {
        try {
            File file = new File(this.parentDirectory, this.fileNameGenerator.generateFileName(message));
            this.writeToFile(file, message.getPayload());
            return file;
        }
        catch (Exception e) {
            throw new MessageHandlingException("failure occurred mapping file to message", (Throwable)e);
        }
    }

    public Message<T> toMessage(File file) {
        T payload;
        block5: {
            try {
                payload = this.readMessagePayload(file);
                if (payload != null) break block5;
                return null;
            }
            catch (Exception e) {
                String errorMessage = "failure occurred mapping file to message";
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)errorMessage, (Throwable)e);
                }
                throw new MessageHandlingException(errorMessage, (Throwable)e);
            }
        }
        GenericMessage message = new GenericMessage((Object)this.getIdGenerator().generateId(), payload);
        if (this.backupDirectory != null) {
            FileWriter writer = new FileWriter(String.valueOf(this.backupDirectory.getAbsolutePath()) + File.separator + file.getName());
            FileCopyUtils.copy((Reader)new FileReader(file), (Writer)writer);
        }
        file.delete();
        return message;
    }

    protected abstract T readMessagePayload(File var1) throws Exception;

    protected abstract void writeToFile(File var1, T var2) throws Exception;
}

