/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.file;

import java.io.File;
import org.springframework.integration.adapter.file.AbstractFileMapper;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayFileMapper
extends AbstractFileMapper<byte[]> {
    public ByteArrayFileMapper(File parentDirectory) {
        super(parentDirectory);
    }

    @Override
    protected byte[] readMessagePayload(File file) throws Exception {
        return FileCopyUtils.copyToByteArray((File)file);
    }

    @Override
    protected void writeToFile(File file, byte[] payload) throws Exception {
        FileCopyUtils.copy((byte[])payload, (File)file);
    }
}

