/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.integration.adapter.PollableSource;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSource
implements PollableSource<File> {
    private File directory;
    private FileFilter fileFilter;
    private FilenameFilter filenameFilter;

    public FileSource(File directory) {
        Assert.notNull((Object)"directory must not be null");
        this.directory = directory;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filenameFilter = filenameFilter;
    }

    public Collection<File> poll(int limit) {
        File[] files = null;
        files = this.fileFilter != null ? this.directory.listFiles(this.fileFilter) : (this.filenameFilter != null ? this.directory.listFiles(this.filenameFilter) : this.directory.listFiles());
        if (files == null) {
            throw new MessageHandlingException("Problem occurred while polling for files. Is '" + this.directory.getAbsolutePath() + "' a directory?");
        }
        int size = Math.min(limit, files.length);
        ArrayList<File> results = new ArrayList<File>(size);
        int i = 0;
        while (i < size) {
            results.add(files[i]);
            ++i;
        }
        return results;
    }
}

