/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.file;

import java.io.File;
import org.springframework.integration.adapter.PollableSource;
import org.springframework.integration.adapter.PollingSourceAdapter;
import org.springframework.integration.adapter.file.AbstractFileMapper;
import org.springframework.integration.adapter.file.ByteArrayFileMapper;
import org.springframework.integration.adapter.file.FileNameGenerator;
import org.springframework.integration.adapter.file.FileSource;
import org.springframework.integration.adapter.file.TextFileMapper;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.MessageMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSourceAdapter
extends PollingSourceAdapter<File> {
    public FileSourceAdapter(File directory, MessageChannel channel, int period) {
        this(directory, channel, period, true);
    }

    public FileSourceAdapter(File directory, MessageChannel channel, int period, boolean isTextBased) {
        super((PollableSource)new FileSource(directory));
        this.setChannel(channel);
        this.setPeriod(period);
        if (isTextBased) {
            this.setMessageMapper((MessageMapper)new TextFileMapper(directory));
        } else {
            this.setMessageMapper((MessageMapper)new ByteArrayFileMapper(directory));
        }
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Assert.notNull((Object)fileNameGenerator, (String)"'fileNameGenerator' must not be null");
        MessageMapper mapper = this.getMessageMapper();
        if (mapper instanceof AbstractFileMapper) {
            ((AbstractFileMapper)mapper).setFileNameGenerator(fileNameGenerator);
        }
    }

    public void setBackupDirectory(File backupDirectory) {
        Assert.notNull((Object)backupDirectory, (String)"'backupDirectory' must not be null");
        MessageMapper mapper = this.getMessageMapper();
        if (mapper != null && mapper instanceof AbstractFileMapper) {
            ((AbstractFileMapper)mapper).setBackupDirectory(backupDirectory);
        }
    }
}

