/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.file;

import java.io.File;
import org.springframework.integration.adapter.AbstractTargetAdapter;
import org.springframework.integration.adapter.file.AbstractFileMapper;
import org.springframework.integration.adapter.file.ByteArrayFileMapper;
import org.springframework.integration.adapter.file.FileNameGenerator;
import org.springframework.integration.adapter.file.TextFileMapper;
import org.springframework.integration.message.MessageMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTargetAdapter
extends AbstractTargetAdapter<File> {
    public FileTargetAdapter(File directory) {
        this(directory, true);
    }

    public FileTargetAdapter(File directory, boolean isTextBased) {
        if (isTextBased) {
            this.setMessageMapper((MessageMapper)new TextFileMapper(directory));
        } else {
            this.setMessageMapper((MessageMapper)new ByteArrayFileMapper(directory));
        }
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Assert.notNull((Object)fileNameGenerator, (String)"'fileNameGenerator' must not be null");
        MessageMapper mapper = this.getMessageMapper();
        if (mapper instanceof AbstractFileMapper) {
            ((AbstractFileMapper)mapper).setFileNameGenerator(fileNameGenerator);
        }
    }

    protected boolean sendToTarget(File file) {
        return file.exists();
    }
}

