/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.file;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.springframework.integration.adapter.file.AbstractFileMapper;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileMapper
extends AbstractFileMapper<String> {
    public TextFileMapper(File parentDirectory) {
        super(parentDirectory);
    }

    @Override
    protected String readMessagePayload(File file) throws Exception {
        return FileCopyUtils.copyToString((Reader)new FileReader(file));
    }

    @Override
    protected void writeToFile(File file, String payload) throws Exception {
        FileCopyUtils.copy((String)payload, (Writer)new FileWriter(file));
    }
}

