/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.jms;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.springframework.integration.MessagingConfigurationException;
import org.springframework.integration.channel.MessageChannel;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageDeliveryException;
import org.springframework.integration.message.MessageMapper;
import org.springframework.integration.message.SimplePayloadMessageMapper;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;

public class ChannelPublishingJmsListener
implements MessageListener {
    private MessageChannel channel;
    private long timeout = -1L;
    private MessageConverter converter = new SimpleMessageConverter();
    private MessageMapper mapper = new SimplePayloadMessageMapper();

    public ChannelPublishingJmsListener() {
    }

    public ChannelPublishingJmsListener(MessageChannel channel) {
        Assert.notNull((Object)channel, (String)"'channel' must not be null");
        this.channel = channel;
    }

    public void setChannel(MessageChannel channel) {
        Assert.notNull((Object)channel, (String)"'channel' must not be null");
        this.channel = channel;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        this.converter = messageConverter;
    }

    public void setMessageMapper(MessageMapper messageMapper) {
        Assert.notNull((Object)messageMapper, (String)"'messageMapper' must not be null");
        this.mapper = messageMapper;
    }

    public void onMessage(javax.jms.Message jmsMessage) {
        if (this.channel == null) {
            throw new MessagingConfigurationException("'channel' must not be null");
        }
        try {
            Object payload = this.converter.fromMessage(jmsMessage);
            Message messageToSend = this.mapper.toMessage(payload);
            if (this.timeout < 0L) {
                this.channel.send(messageToSend);
            } else {
                this.channel.send(messageToSend, this.timeout);
            }
        }
        catch (JMSException e) {
            throw new MessageDeliveryException("failed to convert JMS Message", (Throwable)e);
        }
    }
}

