/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.MessagingConfigurationException;
import org.springframework.integration.adapter.AbstractSourceAdapter;
import org.springframework.integration.adapter.jms.ChannelPublishingJmsListener;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsMessageDrivenSourceAdapter
extends AbstractSourceAdapter<Object>
implements Lifecycle,
DisposableBean {
    private volatile AbstractJmsListeningContainer container;
    private volatile ConnectionFactory connectionFactory;
    private volatile Destination destination;
    private volatile String destinationName;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile TaskExecutor taskExecutor;
    private volatile boolean sessionTransacted;
    private volatile int sessionAcknowledgeMode = 1;
    private volatile long receiveTimeout = 1000L;
    private volatile int concurrentConsumers = 1;
    private volatile int maxConcurrentConsumers = 1;
    private volatile int maxMessagesPerTask = Integer.MIN_VALUE;
    private volatile int idleTaskExecutionLimit = 1;
    private volatile long sendTimeout = -1L;

    public void setContainer(AbstractJmsListeningContainer container) {
        this.container = container;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null");
        this.messageConverter = messageConverter;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    public void setSessionAcknowledgeMode(int sessionAcknowledgeMode) {
        this.sessionAcknowledgeMode = sessionAcknowledgeMode;
    }

    public void initialize() {
        if (this.container == null) {
            this.initDefaultContainer();
        }
    }

    private void initDefaultContainer() {
        if (this.connectionFactory == null || this.destination == null && this.destinationName == null) {
            throw new MessagingConfigurationException("If a 'container' reference is not provided, then 'connectionFactory' and 'destination' (or 'destinationName') are required.");
        }
        DefaultMessageListenerContainer dmlc = new DefaultMessageListenerContainer();
        dmlc.setConnectionFactory(this.connectionFactory);
        if (this.destination != null) {
            dmlc.setDestination(this.destination);
        }
        if (this.destinationName != null) {
            dmlc.setDestinationName(this.destinationName);
        }
        dmlc.setReceiveTimeout(this.receiveTimeout);
        dmlc.setConcurrentConsumers(this.concurrentConsumers);
        dmlc.setMaxConcurrentConsumers(this.maxConcurrentConsumers);
        dmlc.setMaxMessagesPerTask(this.maxMessagesPerTask);
        dmlc.setIdleTaskExecutionLimit(this.idleTaskExecutionLimit);
        dmlc.setSessionTransacted(this.sessionTransacted);
        dmlc.setSessionAcknowledgeMode(this.sessionAcknowledgeMode);
        dmlc.setAutoStartup(false);
        ChannelPublishingJmsListener listener = new ChannelPublishingJmsListener(this.getChannel());
        listener.setMessageConverter(this.messageConverter);
        listener.setMessageMapper(this.getMessageMapper());
        listener.setTimeout(this.sendTimeout);
        dmlc.setMessageListener((Object)listener);
        if (this.taskExecutor != null) {
            dmlc.setTaskExecutor(this.taskExecutor);
        }
        dmlc.afterPropertiesSet();
        this.container = dmlc;
    }

    public boolean isRunning() {
        return this.container.isRunning();
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public void destroy() {
        this.container.destroy();
    }
}

