/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.jms;

import java.util.Arrays;
import java.util.Collection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.MessagingConfigurationException;
import org.springframework.integration.adapter.PollableSource;
import org.springframework.jms.core.JmsTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsPollableSource
implements PollableSource<Object>,
InitializingBean {
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private String destinationName;
    private JmsTemplate jmsTemplate;

    public JmsPollableSource(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public JmsPollableSource(ConnectionFactory connectionFactory, Destination destination) {
        this.connectionFactory = connectionFactory;
        this.destination = destination;
        this.initJmsTemplate();
    }

    public JmsPollableSource(ConnectionFactory connectionFactory, String destinationName) {
        this.connectionFactory = connectionFactory;
        this.destinationName = destinationName;
        this.initJmsTemplate();
    }

    public JmsPollableSource() {
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void afterPropertiesSet() {
        if (this.jmsTemplate == null) {
            if (this.connectionFactory == null || this.destination == null && this.destinationName == null) {
                throw new MessagingConfigurationException("Either a 'jmsTemplate' or both 'connectionFactory' and 'destination' (or 'destinationName') are required.");
            }
            this.initJmsTemplate();
        }
    }

    private void initJmsTemplate() {
        this.jmsTemplate = new JmsTemplate();
        this.jmsTemplate.setConnectionFactory(this.connectionFactory);
        if (this.destination != null) {
            this.jmsTemplate.setDefaultDestination(this.destination);
        } else if (this.destinationName != null) {
            this.jmsTemplate.setDefaultDestinationName(this.destinationName);
        } else {
            throw new MessagingConfigurationException("either 'destination' or 'destinationName' is required");
        }
    }

    public Collection<Object> poll(int limit) {
        return Arrays.asList(this.jmsTemplate.receiveAndConvert());
    }
}

