/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.jms.config;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.integration.adapter.jms.JmsMessageDrivenSourceAdapter;
import org.springframework.integration.adapter.jms.JmsPollingSourceAdapter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsSourceAdapterParser
extends AbstractSingleBeanDefinitionParser {
    private static final String JMS_TEMPLATE_ATTRIBUTE = "jms-template";
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String CONNECTION_FACTORY_PROPERTY = "connectionFactory";
    private static final String DESTINATION_ATTRIBUTE = "destination";
    private static final String DESTINATION_PROPERTY = "destination";
    private static final String DESTINATION_NAME_ATTRIBUTE = "destination-name";
    private static final String DESTINATION_NAME_PROPERTY = "destinationName";
    private static final String CHANNEL_ATTRIBUTE = "channel";
    private static final String CHANNEL_PROPERTY = "channel";
    private static final String POLL_PERIOD_ATTRIBUTE = "poll-period";
    private static final String POLL_PERIOD_PROPERTY = "period";
    private static final String MESSAGE_CONVERTER_ATTRIBUTE = "message-converter";
    private static final String MESSAGE_CONVERTER_PROPERTY = "messageConverter";
    private static final String ACKNOWLEDGE_ATTRIBUTE = "acknowledge";
    private static final String ACKNOWLEDGE_AUTO = "auto";
    private static final String ACKNOWLEDGE_CLIENT = "client";
    private static final String ACKNOWLEDGE_DUPS_OK = "dups-ok";
    private static final String ACKNOWLEDGE_TRANSACTED = "transacted";

    protected Class<?> getBeanClass(Element element) {
        if (StringUtils.hasText((String)element.getAttribute(POLL_PERIOD_ATTRIBUTE))) {
            return JmsPollingSourceAdapter.class;
        }
        return JmsMessageDrivenSourceAdapter.class;
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        if (builder.getBeanDefinition().getBeanClass().equals(JmsPollingSourceAdapter.class)) {
            this.parsePollingSourceAdapter(element, builder);
        } else {
            this.parseMessageDrivenSourceAdapter(element, builder);
        }
        String channel = element.getAttribute("channel");
        builder.addPropertyReference("channel", channel);
    }

    private void parsePollingSourceAdapter(Element element, BeanDefinitionBuilder builder) {
        String pollPeriod = element.getAttribute(POLL_PERIOD_ATTRIBUTE);
        if (!StringUtils.hasText((String)pollPeriod)) {
            throw new BeanCreationException("'poll-period' is required for a " + JmsPollingSourceAdapter.class.getSimpleName());
        }
        if (StringUtils.hasText((String)element.getAttribute(MESSAGE_CONVERTER_ATTRIBUTE))) {
            throw new BeanCreationException("The 'message-converter' attribute is not supported for a " + JmsPollingSourceAdapter.class.getSimpleName() + ". Consider providing a '" + JMS_TEMPLATE_ATTRIBUTE + "' reference where the template contains a 'messageConverter' property instead.");
        }
        builder.addPropertyValue(POLL_PERIOD_PROPERTY, (Object)pollPeriod);
        String jmsTemplate = element.getAttribute(JMS_TEMPLATE_ATTRIBUTE);
        String connectionFactory = element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE);
        String destination = element.getAttribute("destination");
        String destinationName = element.getAttribute(DESTINATION_NAME_ATTRIBUTE);
        if (StringUtils.hasText((String)jmsTemplate)) {
            if (StringUtils.hasText((String)connectionFactory) || StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName)) {
                throw new BeanCreationException("when providing 'jms-template', none of 'connection-factory', 'destination', or 'destination-name' should be provided.");
            }
            builder.addConstructorArgReference(jmsTemplate);
        } else if (StringUtils.hasText((String)connectionFactory) && (StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName))) {
            builder.addConstructorArgReference(connectionFactory);
            if (StringUtils.hasText((String)destination)) {
                builder.addConstructorArgReference(destination);
            } else if (StringUtils.hasText((String)destinationName)) {
                builder.addConstructorArg((Object)destinationName);
            }
        } else {
            throw new BeanCreationException("either a 'jms-template' or both 'connection-factory' and 'destination' (or 'destination-name') attributes must be provided for a " + JmsPollingSourceAdapter.class.getSimpleName());
        }
    }

    private void parseMessageDrivenSourceAdapter(Element element, BeanDefinitionBuilder builder) {
        Integer acknowledgeMode;
        String connectionFactory = element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE);
        String destination = element.getAttribute("destination");
        String destinationName = element.getAttribute(DESTINATION_NAME_ATTRIBUTE);
        String messageConverter = element.getAttribute(MESSAGE_CONVERTER_ATTRIBUTE);
        if (StringUtils.hasText((String)element.getAttribute(JMS_TEMPLATE_ATTRIBUTE))) {
            throw new BeanCreationException(String.valueOf(JmsMessageDrivenSourceAdapter.class.getSimpleName()) + " does not accept a '" + JMS_TEMPLATE_ATTRIBUTE + "' reference. Both " + "'" + CONNECTION_FACTORY_ATTRIBUTE + "' and '" + "destination" + "' (or '" + DESTINATION_NAME_ATTRIBUTE + "') must be provided.");
        }
        if (StringUtils.hasText((String)connectionFactory) && (StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName))) {
            builder.addPropertyReference(CONNECTION_FACTORY_PROPERTY, connectionFactory);
            if (StringUtils.hasText((String)destination)) {
                builder.addPropertyReference("destination", destination);
            } else {
                builder.addPropertyValue(DESTINATION_NAME_PROPERTY, (Object)destinationName);
            }
        } else {
            throw new BeanCreationException("Both 'connection-factory' and 'destination' (or 'destination-name') must be provided.");
        }
        if (StringUtils.hasText((String)messageConverter)) {
            builder.addPropertyReference(MESSAGE_CONVERTER_PROPERTY, messageConverter);
        }
        if ((acknowledgeMode = this.parseAcknowledgeMode(element)) != null) {
            if (acknowledgeMode == 0) {
                builder.addPropertyValue("sessionTransacted", (Object)Boolean.TRUE);
            } else {
                builder.addPropertyValue("sessionAcknowledgeMode", (Object)acknowledgeMode);
            }
        }
    }

    private Integer parseAcknowledgeMode(Element element) {
        String acknowledge = element.getAttribute(ACKNOWLEDGE_ATTRIBUTE);
        if (StringUtils.hasText((String)acknowledge)) {
            int acknowledgeMode = 1;
            if (ACKNOWLEDGE_TRANSACTED.equals(acknowledge)) {
                acknowledgeMode = 0;
            } else if (ACKNOWLEDGE_DUPS_OK.equals(acknowledge)) {
                acknowledgeMode = 3;
            } else if (ACKNOWLEDGE_CLIENT.equals(acknowledge)) {
                acknowledgeMode = 2;
            } else if (!ACKNOWLEDGE_AUTO.equals(acknowledge)) {
                throw new BeanCreationException("Invalid jms-source 'acknowledge' setting: only \"auto\", \"client\", \"dups-ok\" and \"transacted\" supported.");
            }
            return acknowledgeMode;
        }
        return null;
    }
}

