/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.jms.config;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.adapter.jms.JmsTargetAdapter;
import org.springframework.integration.endpoint.DefaultMessageEndpoint;
import org.springframework.integration.scheduling.Subscription;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsTargetAdapterParser
extends AbstractSingleBeanDefinitionParser {
    private static final String JMS_TEMPLATE_ATTRIBUTE = "jms-template";
    private static final String JMS_TEMPLATE_PROPERTY = "jmsTemplate";
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String CONNECTION_FACTORY_PROPERTY = "connectionFactory";
    private static final String DESTINATION_ATTRIBUTE = "destination";
    private static final String DESTINATION_NAME_ATTRIBUTE = "destination-name";
    private static final String DESTINATION_PROPERTY = "destination";
    private static final String DESTINATION_NAME_PROPERTY = "destinationName";
    private static final String CHANNEL_ATTRIBUTE = "channel";
    private static final String HANDLER_PROPERTY = "handler";
    private static final String SUBSCRIPTION_PROPERTY = "subscription";

    protected Class<?> getBeanClass(Element element) {
        return DefaultMessageEndpoint.class;
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String jmsTemplate = element.getAttribute(JMS_TEMPLATE_ATTRIBUTE);
        String connectionFactory = element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE);
        String destination = element.getAttribute("destination");
        String destinationName = element.getAttribute(DESTINATION_NAME_ATTRIBUTE);
        RootBeanDefinition adapterDef = new RootBeanDefinition(JmsTargetAdapter.class);
        if (StringUtils.hasText((String)jmsTemplate)) {
            if (StringUtils.hasText((String)connectionFactory) || StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName)) {
                throw new BeanCreationException("when providing a 'jms-template' reference, none of 'connection-factory', 'destination', or 'destination-name' should be provided.");
            }
            adapterDef.getPropertyValues().addPropertyValue(JMS_TEMPLATE_PROPERTY, (Object)new RuntimeBeanReference(jmsTemplate));
        } else if (StringUtils.hasText((String)connectionFactory) && StringUtils.hasText((String)destination) ^ StringUtils.hasText((String)destinationName)) {
            adapterDef.getPropertyValues().addPropertyValue(CONNECTION_FACTORY_PROPERTY, (Object)new RuntimeBeanReference(connectionFactory));
            if (StringUtils.hasText((String)destination)) {
                adapterDef.getPropertyValues().addPropertyValue("destination", (Object)new RuntimeBeanReference(destination));
            } else {
                adapterDef.getPropertyValues().addPropertyValue(DESTINATION_NAME_PROPERTY, (Object)destinationName);
            }
        } else {
            throw new BeanCreationException("either a 'jms-template' reference or both 'connection-factory' and 'destination' (or 'destination-name') references must be provided.");
        }
        String channel = element.getAttribute(CHANNEL_ATTRIBUTE);
        Subscription subscription = new Subscription(channel);
        String adapterBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)adapterDef);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)adapterDef, adapterBeanName));
        builder.addPropertyReference(HANDLER_PROPERTY, adapterBeanName);
        builder.addPropertyValue(SUBSCRIPTION_PROPERTY, (Object)subscription);
    }
}

