/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.mail;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.integration.message.AbstractMessageMapper;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageHandlingException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayMailMessageMapper
extends AbstractMessageMapper<byte[], MailMessage> {
    private final JavaMailSender mailSender;
    private volatile int multipartMode = 1;
    private volatile String attachmentFilename = "content";

    public ByteArrayMailMessageMapper(JavaMailSender mailSender) {
        Assert.notNull((Object)mailSender, (String)"'mailSender' must not be null");
        this.mailSender = mailSender;
    }

    public void setMultipartMode(int multipartMode) {
        this.multipartMode = multipartMode;
    }

    public void setAttachmentFilename(String attachmentFilename) {
        this.attachmentFilename = attachmentFilename;
    }

    public Message<byte[]> toMessage(MailMessage source) {
        throw new UnsupportedOperationException("mapping from MailMessage to byte array not supported");
    }

    public MailMessage fromMessage(Message<byte[]> message) {
        try {
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, this.multipartMode);
            helper.addAttachment(this.attachmentFilename, (InputStreamSource)new ByteArrayResource((byte[])message.getPayload()));
            return new MimeMailMessage(helper);
        }
        catch (MessagingException e) {
            throw new MessageHandlingException("failed to create MimeMessage", (Throwable)e);
        }
    }
}

