/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.mail;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.adapter.mail.ByteArrayMailMessageMapper;
import org.springframework.integration.adapter.mail.MailHeaderGenerator;
import org.springframework.integration.adapter.mail.TextMailMessageMapper;
import org.springframework.integration.handler.MessageHandler;
import org.springframework.integration.message.AbstractMessageMapper;
import org.springframework.integration.message.Message;
import org.springframework.integration.message.MessageMapper;
import org.springframework.mail.MailMessage;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailTargetAdapter
implements MessageHandler,
InitializingBean {
    private volatile JavaMailSender mailSender;
    private volatile MailHeaderGenerator mailHeaderGenerator;
    private volatile MessageMapper<String, MailMessage> textMessageMapper;
    private volatile MessageMapper<byte[], MailMessage> byteArrayMessageMapper;
    private volatile MessageMapper<Object, MailMessage> objectMessageMapper;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.mailSender, (String)"'mailSender' must not be null");
        Assert.notNull((Object)this.mailHeaderGenerator, (String)"'mailHeaderGenerator' must not be null");
        this.textMessageMapper = this.textMessageMapper != null ? this.textMessageMapper : new TextMailMessageMapper();
        this.byteArrayMessageMapper = this.byteArrayMessageMapper != null ? this.byteArrayMessageMapper : new ByteArrayMailMessageMapper(this.mailSender);
        this.objectMessageMapper = this.objectMessageMapper != null ? this.objectMessageMapper : new DefaultObjectMailMessageMapper();
    }

    public void setMailSender(JavaMailSender mailSender) {
        Assert.notNull((Object)mailSender, (String)"'mailSender' must not be null");
        this.mailSender = mailSender;
    }

    public void setHeaderGenerator(MailHeaderGenerator mailHeaderGenerator) {
        Assert.notNull((Object)mailHeaderGenerator, (String)"'mailHeaderGenerator' must not be null");
        this.mailHeaderGenerator = mailHeaderGenerator;
    }

    public void setTextMessageMapper(MessageMapper<String, MailMessage> textMessageMapper) {
        this.textMessageMapper = textMessageMapper;
    }

    public void setByteArrayMessageMapper(MessageMapper<byte[], MailMessage> byteArrayMessageMapper) {
        this.byteArrayMessageMapper = byteArrayMessageMapper;
    }

    public void setObjectMessageMapper(MessageMapper<Object, MailMessage> objectMessageMapper) {
        this.objectMessageMapper = objectMessageMapper;
    }

    public Message<?> handle(Message<?> message) {
        MailMessage mailMessage = this.convertMessageToMailMessage(message);
        this.mailHeaderGenerator.populateMailMessageHeader(mailMessage, message);
        this.sendMailMessage(mailMessage);
        return null;
    }

    public MailMessage convertMessageToMailMessage(Message<?> message) {
        if (message.getPayload() instanceof String) {
            return (MailMessage)this.textMessageMapper.fromMessage(message);
        }
        if (message.getPayload() instanceof byte[]) {
            return (MailMessage)this.byteArrayMessageMapper.fromMessage(message);
        }
        return (MailMessage)this.objectMessageMapper.fromMessage(message);
    }

    private void sendMailMessage(MailMessage mailMessage) {
        if (mailMessage instanceof SimpleMailMessage) {
            this.mailSender.send((SimpleMailMessage)mailMessage);
        } else if (mailMessage instanceof MimeMailMessage) {
            this.mailSender.send(((MimeMailMessage)mailMessage).getMimeMessage());
        } else {
            throw new IllegalArgumentException("MailMessage subclass '" + mailMessage.getClass().getName() + "' not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultObjectMailMessageMapper
    extends AbstractMessageMapper<Object, MailMessage> {
        private DefaultObjectMailMessageMapper() {
        }

        public Message<Object> toMessage(MailMessage source) {
            throw new UnsupportedOperationException("mapping from MailMessage to Object not supported");
        }

        public MailMessage fromMessage(Message<Object> objectMessage) {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setText(objectMessage.getPayload().toString());
            return message;
        }
    }
}

