/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.stream;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.integration.adapter.PollableSource;
import org.springframework.integration.message.MessageDeliveryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteStreamSource
implements PollableSource<byte[]> {
    private BufferedInputStream stream;
    private Object streamMonitor;
    private int bytesPerMessage = 1024;
    private boolean shouldTruncate = true;

    public ByteStreamSource(InputStream stream) {
        this(stream, -1);
    }

    public ByteStreamSource(InputStream stream, int bufferSize) {
        this.streamMonitor = stream;
        this.stream = stream instanceof BufferedInputStream ? (BufferedInputStream)stream : (bufferSize > 0 ? new BufferedInputStream(stream, bufferSize) : new BufferedInputStream(stream));
    }

    public void setBytesPerMessage(int bytesPerMessage) {
        this.bytesPerMessage = bytesPerMessage;
    }

    public void setShouldTruncate(boolean shouldTruncate) {
        this.shouldTruncate = shouldTruncate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<byte[]> poll(int limit) {
        ArrayList<byte[]> results = new ArrayList<byte[]>();
        while (results.size() < limit) {
            try {
                byte[] bytes;
                int bytesRead = 0;
                Object object = this.streamMonitor;
                synchronized (object) {
                    if (this.stream.available() == 0) {
                        return results;
                    }
                    bytes = new byte[this.bytesPerMessage];
                    bytesRead = this.stream.read(bytes, 0, bytes.length);
                }
                if (bytesRead <= 0) {
                    return results;
                }
                if (!this.shouldTruncate) {
                    results.add(bytes);
                    continue;
                }
                byte[] result = new byte[bytesRead];
                System.arraycopy(bytes, 0, result, 0, result.length);
                results.add(result);
            }
            catch (IOException e) {
                throw new MessageDeliveryException("IO failure occurred in adapter", (Throwable)e);
            }
        }
        return results;
    }
}

