/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.stream;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.integration.adapter.AbstractTargetAdapter;
import org.springframework.integration.message.MessageHandlingException;

public class ByteStreamTargetAdapter
extends AbstractTargetAdapter {
    private BufferedOutputStream stream;

    public ByteStreamTargetAdapter(OutputStream stream) {
        this(stream, -1);
    }

    public ByteStreamTargetAdapter(OutputStream stream, int bufferSize) {
        this.stream = bufferSize > 0 ? new BufferedOutputStream(stream, bufferSize) : new BufferedOutputStream(stream);
    }

    protected boolean sendToTarget(Object object) {
        if (object == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " received null object"));
            }
            return false;
        }
        try {
            if (object instanceof String) {
                this.stream.write(((String)object).getBytes());
            } else if (object instanceof byte[]) {
                this.stream.write((byte[])object);
            } else {
                throw new MessageHandlingException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " only supports byte array and String-based messages");
            }
            this.stream.flush();
            return true;
        }
        catch (IOException e) {
            throw new MessageHandlingException("IO failure occurred in adapter", (Throwable)e);
        }
    }
}

