/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.integration.adapter.PollableSource;
import org.springframework.integration.message.MessageDeliveryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterStreamSource
implements PollableSource<String> {
    private BufferedReader reader;
    private Object streamMonitor;

    public CharacterStreamSource(InputStream stream) {
        this(stream, -1);
    }

    public CharacterStreamSource(InputStream stream, int bufferSize) {
        this.streamMonitor = stream;
        this.reader = bufferSize > 0 ? new BufferedReader(new InputStreamReader(stream), bufferSize) : new BufferedReader(new InputStreamReader(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> poll(int limit) {
        ArrayList<String> results = new ArrayList<String>();
        while (results.size() < limit) {
            try {
                String line = null;
                Object object = this.streamMonitor;
                synchronized (object) {
                    boolean isReady = this.reader.ready();
                    if (!isReady) {
                        return results;
                    }
                    line = this.reader.readLine();
                }
                if (line == null) {
                    return results;
                }
                results.add(line);
            }
            catch (IOException e) {
                throw new MessageDeliveryException("IO failure occurred in adapter", (Throwable)e);
            }
        }
        return results;
    }
}

