/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.stream;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.springframework.integration.adapter.AbstractTargetAdapter;
import org.springframework.integration.message.MessageHandlingException;

public class CharacterStreamTargetAdapter
extends AbstractTargetAdapter {
    private BufferedWriter writer;
    private boolean shouldAppendNewLine = false;

    public CharacterStreamTargetAdapter(OutputStream stream) {
        this(stream, -1);
    }

    public CharacterStreamTargetAdapter(OutputStream stream, int bufferSize) {
        this.writer = bufferSize > 0 ? new BufferedWriter(new OutputStreamWriter(stream), bufferSize) : new BufferedWriter(new OutputStreamWriter(stream));
    }

    public static CharacterStreamTargetAdapter stdoutAdapter() {
        return new CharacterStreamTargetAdapter(System.out);
    }

    public static CharacterStreamTargetAdapter stderrAdapter() {
        return new CharacterStreamTargetAdapter(System.err);
    }

    public void setShouldAppendNewLine(boolean shouldAppendNewLine) {
        this.shouldAppendNewLine = shouldAppendNewLine;
    }

    protected boolean sendToTarget(Object object) {
        if (object == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"target adapter received null object");
            }
            return false;
        }
        try {
            if (object instanceof String) {
                this.writer.write((String)object);
            } else {
                this.writer.write(object.toString());
            }
            if (this.shouldAppendNewLine) {
                this.writer.newLine();
            }
            this.writer.flush();
            return true;
        }
        catch (IOException e) {
            throw new MessageHandlingException("IO failure occurred in adapter", (Throwable)e);
        }
    }
}

