/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.util.List;
import org.springframework.integration.core.MessagingException;
import org.springframework.integration.file.AcceptOnceFileListFilter;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileListFilter;
import org.springframework.integration.file.locking.FileLocker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDirectoryScanner
implements DirectoryScanner {
    private FileListFilter filter = new AcceptOnceFileListFilter();
    private FileLocker locker;

    @Override
    public final List<File> listFiles(File directory) throws IllegalArgumentException {
        File[] files = this.listEligibleFiles(directory);
        if (files == null) {
            throw new MessagingException("The path [" + directory + "] does not denote a properly accessible directory.");
        }
        return this.filter.filterFiles(files);
    }

    protected File[] listEligibleFiles(File directory) {
        return directory.listFiles();
    }

    @Override
    public final void setFilter(FileListFilter filter) {
        this.filter = filter;
    }

    @Override
    public final boolean tryClaim(File file) {
        return this.locker != null ? this.locker.lock(file) : true;
    }

    @Override
    public final void setLocker(FileLocker locker) {
        this.locker = locker;
    }
}

