/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import org.springframework.integration.core.Message;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileNameGenerator
implements FileNameGenerator {
    private volatile String headerName = "$file_name";

    public void setHeaderName(String headerName) {
        Assert.notNull((Object)headerName, (String)"'headerName' must not be null");
        this.headerName = headerName;
    }

    @Override
    public String generateFileName(Message<?> message) {
        Object filenameProperty = message.getHeaders().get((Object)this.headerName);
        if (filenameProperty instanceof String && StringUtils.hasText((String)((String)filenameProperty))) {
            return (String)filenameProperty;
        }
        if (message.getPayload() instanceof File) {
            return ((File)message.getPayload()).getName();
        }
        return message.getHeaders().getId() + ".msg";
    }
}

