/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FileInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    private static final String PACKAGE_NAME = "org.springframework.integration.file";

    protected String parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.file.config.FileReadingMessageSourceFactoryBean");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"comparator");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"scanner");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-create-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"queue-size");
        String filterBeanName = this.registerFilter(element, parserContext);
        String lockerBeanName = this.registerLocker(element, parserContext);
        if (lockerBeanName != null) {
            builder.addPropertyReference("locker", lockerBeanName);
        }
        builder.addPropertyReference("filter", filterBeanName);
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }

    private String registerLocker(Element element, ParserContext parserContext) {
        String lockerBeanName = null;
        Element nioLocker = DomUtils.getChildElementByTagName((Element)element, (String)"nio-locker");
        if (nioLocker != null) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.file.locking.NioFileLocker");
            lockerBeanName = BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        } else {
            Element locker = DomUtils.getChildElementByTagName((Element)element, (String)"locker");
            if (locker != null) {
                lockerBeanName = locker.getAttribute("ref");
            }
        }
        return lockerBeanName;
    }

    private String registerFilter(Element element, ParserContext parserContext) {
        String preventDuplicates;
        String filenamePattern;
        BeanDefinitionBuilder factoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.file.config.FileListFilterFactoryBean");
        factoryBeanBuilder.setRole(1);
        String filter = element.getAttribute("filter");
        if (StringUtils.hasText((String)filter)) {
            factoryBeanBuilder.addPropertyReference("filterReference", filter);
        }
        if (StringUtils.hasText((String)(filenamePattern = element.getAttribute("filename-pattern")))) {
            if (StringUtils.hasText((String)filter)) {
                parserContext.getReaderContext().error("At most one of 'filter' and 'filename-pattern' may be provided.", (Object)element);
            }
            factoryBeanBuilder.addPropertyValue("filenamePattern", (Object)filenamePattern);
        }
        if (StringUtils.hasText((String)(preventDuplicates = element.getAttribute("prevent-duplicates")))) {
            factoryBeanBuilder.addPropertyValue("preventDuplicates", (Object)preventDuplicates);
        }
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)factoryBeanBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }
}

