/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.core.io.ResourceLoader;
import org.springframework.integration.channel.ChannelResolver;
import org.springframework.integration.core.MessageChannel;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.FileWritingMessageHandler;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWritingMessageHandlerFactoryBean
implements FactoryBean,
BeanFactoryAware,
ResourceLoaderAware {
    private volatile FileWritingMessageHandler handler;
    private volatile ResourceLoader resourceLoader;
    private volatile BeanFactory beanFactory;
    private volatile String directory;
    private volatile MessageChannel outputChannel;
    private volatile ChannelResolver channelResolver;
    private volatile String charset;
    private volatile FileNameGenerator fileNameGenerator;
    private volatile Boolean deleteSourceFiles;
    private volatile Boolean autoCreateDirectory;
    private volatile Boolean requiresReply;
    private volatile Long sendTimeout;
    private volatile Integer order;
    private final Object initializationMonitor = new Object();

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setDirectory(String directory) {
        Assert.hasText((String)directory, (String)"directory must not be empty");
        if (directory.indexOf(58) == -1) {
            directory = "file:" + directory;
        }
        this.directory = directory;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setChannelResolver(ChannelResolver channelResolver) {
        this.channelResolver = channelResolver;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
    }

    public void setDeleteSourceFiles(Boolean deleteSourceFiles) {
        this.deleteSourceFiles = deleteSourceFiles;
    }

    public void setAutoCreateDirectory(Boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setRequiresReply(Boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Object getObject() throws Exception {
        if (this.handler == null) {
            this.initHandler();
        }
        return this.handler;
    }

    public Class<?> getObjectType() {
        return FileWritingMessageHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHandler() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.handler != null) {
                return;
            }
            ResourceEditor editor = new ResourceEditor(this.resourceLoader);
            editor.setAsText(this.directory);
            this.handler = new FileWritingMessageHandler((Resource)editor.getValue());
            if (this.outputChannel != null) {
                this.handler.setOutputChannel(this.outputChannel);
            }
            if (this.channelResolver != null) {
                this.handler.setChannelResolver(this.channelResolver);
            }
            if (this.charset != null) {
                this.handler.setCharset(this.charset);
            }
            if (this.fileNameGenerator != null) {
                this.handler.setFileNameGenerator(this.fileNameGenerator);
            }
            if (this.deleteSourceFiles != null) {
                this.handler.setDeleteSourceFiles(this.deleteSourceFiles);
            }
            if (this.autoCreateDirectory != null) {
                this.handler.setAutoCreateDirectory(this.autoCreateDirectory);
            }
            if (this.requiresReply != null) {
                this.handler.setRequiresReply(this.requiresReply);
            }
            if (this.sendTimeout != null) {
                this.handler.setSendTimeout(this.sendTimeout);
            }
            if (this.order != null) {
                this.handler.setOrder(this.order);
            }
            this.handler.setBeanFactory(this.beanFactory);
            this.handler.afterPropertiesSet();
        }
    }
}

