/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.core.Message;
import org.springframework.integration.http.InboundRequestMapper;
import org.springframework.integration.http.ResponseStatusCodeException;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInboundRequestMapper
implements InboundRequestMapper {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile MultipartResolver multipartResolver;
    private volatile String multipartCharset = null;
    private volatile boolean copyUploadedFiles;

    public void setMultipartResolver(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    public void setMultipartCharset(String multipartCharset) {
        this.multipartCharset = multipartCharset;
    }

    public void setCopyUploadedFiles(boolean copyUploadedFiles) {
        this.copyUploadedFiles = copyUploadedFiles;
    }

    public Message<?> toMessage(HttpServletRequest request) throws Exception {
        try {
            request = this.checkMultipart(request);
            Object payload = this.createPayloadFromRequest(request);
            MessageBuilder builder = MessageBuilder.withPayload((Object)payload);
            this.populateHeaders(request, builder);
            Message message = builder.build();
            return message;
        }
        finally {
            this.cleanupMultipart(request);
        }
    }

    private HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
            if (request instanceof MultipartHttpServletRequest) {
                this.logger.debug((Object)"Request is already a MultipartHttpServletRequest");
            } else {
                return this.multipartResolver.resolveMultipart(request);
            }
        }
        return request;
    }

    private void cleanupMultipart(HttpServletRequest request) {
        if (this.multipartResolver != null && request instanceof MultipartHttpServletRequest) {
            this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)request);
        }
    }

    private Object createPayloadFromRequest(HttpServletRequest request) throws Exception {
        String contentType;
        Object payload = null;
        String string = contentType = request.getContentType() != null ? request.getContentType() : "";
        if (request instanceof MultipartHttpServletRequest) {
            payload = this.createPayloadFromMultipartRequest((MultipartHttpServletRequest)request);
        } else {
            if (contentType.startsWith("multipart/form-data")) {
                throw new IllegalArgumentException("Content-Type of 'multipart/form-data' requires a MultipartResolver. Try configuring a MultipartResolver within the ApplicationContext.");
            }
            if (request.getMethod().equals("GET")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"received GET request, using parameter map as payload");
                }
                payload = this.createPayloadFromParameterMap(request);
            } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("received " + request.getMethod() + " request with form data, using parameter map as payload"));
                }
                payload = this.createPayloadFromParameterMap(request);
            } else if (contentType.startsWith("text")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("received " + request.getMethod() + " request, creating payload with text content"));
                }
                payload = this.createPayloadFromTextContent(request);
            } else {
                payload = contentType.startsWith("application/x-java-serialized-object") ? this.createPayloadFromSerializedObject(request) : (Object)this.createPayloadFromInputStream(request);
            }
        }
        return payload;
    }

    private Object createPayloadFromMultipartRequest(MultipartHttpServletRequest multipartRequest) {
        HashMap<String, Object> payloadMap = new HashMap<String, Object>(multipartRequest.getParameterMap());
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entry : fileMap.entrySet()) {
            MultipartFile multipartFile = (MultipartFile)entry.getValue();
            if (multipartFile.isEmpty()) continue;
            try {
                if (this.copyUploadedFiles) {
                    File tmpFile = File.createTempFile("si_", null);
                    multipartFile.transferTo(tmpFile);
                    payloadMap.put((String)entry.getKey(), tmpFile);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("copied uploaded file [" + multipartFile.getOriginalFilename() + "] to temporary file [" + tmpFile.getAbsolutePath() + "]"));
                    continue;
                }
                if (multipartFile.getContentType() != null && multipartFile.getContentType().startsWith("text")) {
                    String multipartFileAsString = this.multipartCharset != null ? new String(multipartFile.getBytes(), this.multipartCharset) : new String(multipartFile.getBytes());
                    payloadMap.put((String)entry.getKey(), multipartFileAsString);
                    continue;
                }
                payloadMap.put((String)entry.getKey(), multipartFile.getBytes());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read contents of multipart file", e);
            }
        }
        return Collections.unmodifiableMap(payloadMap);
    }

    private Object createPayloadFromParameterMap(HttpServletRequest request) {
        HashMap parameterMap = new HashMap(request.getParameterMap());
        return Collections.unmodifiableMap(parameterMap);
    }

    private Object createPayloadFromTextContent(HttpServletRequest request) throws IOException {
        String charset = request.getCharacterEncoding() != null ? request.getCharacterEncoding() : "utf-8";
        return new String(FileCopyUtils.copyToByteArray((InputStream)request.getInputStream()), charset);
    }

    private Object createPayloadFromSerializedObject(HttpServletRequest request) {
        try {
            return new ObjectInputStream((InputStream)request.getInputStream()).readObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to deserialize Object in request", e);
        }
    }

    private byte[] createPayloadFromInputStream(HttpServletRequest request) throws Exception {
        ServletInputStream stream = request.getInputStream();
        int length = request.getContentLength();
        if (length == -1) {
            throw new ResponseStatusCodeException(411);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("received " + request.getMethod() + " request, " + "creating byte array payload with content lenth: " + length));
        }
        byte[] bytes = new byte[length];
        stream.read(bytes, 0, length);
        return bytes;
    }

    private void populateHeaders(HttpServletRequest request, MessageBuilder<?> builder) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerEnum = request.getHeaders(headerName);
                if (headerEnum == null) continue;
                ArrayList headers = new ArrayList();
                while (headerEnum.hasMoreElements()) {
                    headers.add(headerEnum.nextElement());
                }
                if (headers.size() == 1) {
                    builder.setHeader(headerName, headers.get(0));
                    continue;
                }
                if (headers.size() <= 1) continue;
                builder.setHeader(headerName, headers);
            }
        }
        builder.setHeader("springintegration_http_requestUrl", (Object)request.getRequestURL().toString());
        builder.setHeader("springintegration_http_requestMethod", (Object)request.getMethod());
        builder.setHeader("springintegration_http_userPrincipal", (Object)request.getUserPrincipal());
    }
}

