/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.core.Message;
import org.springframework.integration.http.HttpRequest;
import org.springframework.integration.http.OutboundRequestMapper;
import org.springframework.integration.message.MessageDeliveryException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOutboundRequestMapper
implements OutboundRequestMapper {
    private volatile URL defaultUrl;
    private volatile boolean extractPayload = true;
    private volatile String charset = "UTF-8";

    public DefaultOutboundRequestMapper() {
    }

    public DefaultOutboundRequestMapper(URL defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public void setDefaultUrl(URL defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public void setExtractPayload(boolean extractPayload) {
        this.extractPayload = extractPayload;
    }

    public void setCharset(String charset) {
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("unsupported charset '" + charset + "'"));
        this.charset = charset;
    }

    public HttpRequest fromMessage(Message<?> message) throws Exception {
        String requestMethod;
        Assert.notNull(message, (String)"message must not be null");
        URL url = this.resolveUrl(message);
        if (url == null) {
            throw new MessageDeliveryException(message, "failed to determine a target URL for Message");
        }
        Object requestMethodHeader = message.getHeaders().get((Object)"springintegration_http_requestMethod");
        String string = requestMethod = requestMethodHeader != null ? requestMethodHeader.toString().toUpperCase() : "POST";
        if (this.extractPayload) {
            Object payload = message.getPayload();
            Assert.notNull((Object)payload, (String)"payload must not be null");
            return this.createRequestFromPayload(payload, url, requestMethod);
        }
        return this.createRequestFromMessage(message, url, requestMethod);
    }

    private HttpRequest createRequestFromPayload(Object payload, URL url, String requestMethod) throws Exception {
        ByteArrayOutputStream requestBody = new ByteArrayOutputStream();
        String contentType = null;
        if ("POST".equals(requestMethod) || "PUT".equals(requestMethod)) {
            contentType = this.writeToRequestBody(payload, requestBody);
        } else {
            Assert.isTrue((boolean)(payload instanceof Map), (String)("Message payload must be a Map for a '" + requestMethod + "' request."));
            Map<String, String[]> parameterMap = this.createParameterMap((Map)payload);
            Assert.notNull(parameterMap, (String)("Payload must be a Map with String typed keys and String or String array typed values for a '" + requestMethod + "' request."));
            url = this.addQueryParametersToUrl(url, parameterMap);
        }
        return new DefaultHttpRequest(url, requestMethod, requestBody, contentType);
    }

    private HttpRequest createRequestFromMessage(Message<?> message, URL url, String requestMethod) throws Exception {
        Assert.isTrue(("POST".equals(requestMethod) || "PUT".equals(requestMethod) ? 1 : 0) != 0, (String)"POST or PUT request method is required when the 'extractPayload' value is false.");
        ByteArrayOutputStream requestBody = new ByteArrayOutputStream();
        String contentType = this.writeToRequestBody(message, requestBody);
        return new DefaultHttpRequest(url, requestMethod, requestBody, contentType);
    }

    private Map<String, String[]> createParameterMap(Map<?, ?> map) {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        for (Object key : map.keySet()) {
            if (!(key instanceof String)) {
                return null;
            }
            String[] stringArrayValue = null;
            Object value = map.get(key);
            if (value instanceof String) {
                stringArrayValue = new String[]{(String)value};
            } else if (value instanceof String[]) {
                stringArrayValue = (String[])value;
            } else {
                return null;
            }
            parameterMap.put((String)key, stringArrayValue);
        }
        return parameterMap;
    }

    private String writeToRequestBody(Object object, ByteArrayOutputStream byteStream) throws Exception {
        String contentType = null;
        if (object instanceof byte[]) {
            byteStream.write((byte[])object);
            contentType = "application/octet-stream";
        } else if (object instanceof String) {
            byteStream.write(((String)object).getBytes(this.charset));
            contentType = "text/plain; charset=" + this.charset;
        } else if (object instanceof Serializable) {
            byteStream.write(this.serializeObject((Serializable)object));
            contentType = "application/x-java-serialized-object";
        } else {
            throw new IllegalArgumentException("payload must be a byte array, String, or Serializable object for a 'POST' or 'PUT' request");
        }
        return contentType;
    }

    private byte[] serializeObject(Serializable object) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
        objectStream.writeObject(object);
        objectStream.flush();
        objectStream.close();
        return byteStream.toByteArray();
    }

    private URL resolveUrl(Message<?> message) throws MalformedURLException {
        Object urlHeader = message.getHeaders().get((Object)"springintegration_http_requestUrl");
        if (urlHeader == null) {
            return this.defaultUrl;
        }
        if (urlHeader instanceof URL) {
            return (URL)urlHeader;
        }
        if (urlHeader instanceof URI) {
            return ((URI)urlHeader).toURL();
        }
        if (urlHeader instanceof String) {
            return new URL((String)urlHeader);
        }
        throw new IllegalArgumentException("Target URL in Message header must be a URL, URI, or String.");
    }

    private URL addQueryParametersToUrl(URL url, Map<String, String[]> parameterMap) throws Exception {
        if (parameterMap == null || parameterMap.size() == 0) {
            return url;
        }
        String urlString = url.toExternalForm();
        String fragment = "";
        int fragmentStartIndex = urlString.indexOf(35);
        if (fragmentStartIndex != -1) {
            fragment = urlString.substring(fragmentStartIndex);
            urlString = urlString.substring(0, fragmentStartIndex);
        }
        StringBuilder sb = new StringBuilder(urlString);
        if (urlString.indexOf(63) == -1) {
            sb.append('?');
        }
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] values;
            String[] stringArray = values = entry.getValue();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                char lastChar = sb.charAt(sb.length() - 1);
                if (lastChar != '?' && lastChar != '&') {
                    sb.append('&');
                }
                sb.append(String.valueOf(URLEncoder.encode(entry.getKey(), this.charset)) + "=");
                sb.append(URLEncoder.encode(value, this.charset));
                ++n2;
            }
        }
        sb.append(fragment);
        return new URL(sb.toString());
    }

    class DefaultHttpRequest
    implements HttpRequest {
        private final URL targetUrl;
        private final String requestMethod;
        private final String contentType;
        private volatile ByteArrayOutputStream requestBody;

        DefaultHttpRequest(URL targetUrl, String requestMethod, ByteArrayOutputStream requestBody, String contentType) throws IOException {
            Assert.notNull((Object)targetUrl, (String)"target url must not be null");
            this.targetUrl = targetUrl;
            this.requestMethod = requestMethod != null ? requestMethod : "POST";
            this.requestBody = requestBody;
            this.contentType = contentType;
        }

        public URL getTargetUrl() {
            return this.targetUrl;
        }

        public String getRequestMethod() {
            return this.requestMethod;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Integer getContentLength() {
            return this.requestBody != null ? Integer.valueOf(this.requestBody.size()) : null;
        }

        public ByteArrayOutputStream getBody() {
            return this.requestBody;
        }
    }
}

