/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.container.jms;

import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.NameMatchMethodPointcut;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class BatchMessageListenerContainer
extends DefaultMessageListenerContainer {
    private Advice[] advices = new Advice[0];
    private ContainerDelegate delegate;
    private ContainerDelegate proxy = this.delegate = new ContainerDelegate(){

        public boolean receiveAndExecute(Object invoker, Session session, MessageConsumer consumer) throws JMSException {
            return BatchMessageListenerContainer.super.receiveAndExecute(invoker, session, consumer);
        }
    };

    public void setAdviceChain(Advice[] advices) {
        this.advices = advices;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.initializeProxy();
    }

    protected void handleListenerException(Throwable ex) {
        if (!this.isSessionTransacted()) {
            super.handleListenerException(ex);
            return;
        }
        this.logger.debug((Object)"Re-throwing exception in container.");
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
    }

    protected boolean receiveAndExecute(Object invoker, Session session, MessageConsumer consumer) throws JMSException {
        return this.proxy.receiveAndExecute(invoker, session, consumer);
    }

    public void initializeProxy() {
        ProxyFactory factory = new ProxyFactory();
        for (int i = 0; i < this.advices.length; ++i) {
            DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor(this.advices[i]);
            NameMatchMethodPointcut pointcut = new NameMatchMethodPointcut();
            pointcut.addMethodName("receiveAndExecute");
            advisor.setPointcut((Pointcut)pointcut);
            factory.addAdvisor((Advisor)advisor);
        }
        factory.setProxyTargetClass(false);
        factory.addInterface(ContainerDelegate.class);
        factory.setTarget((Object)this.delegate);
        this.proxy = (ContainerDelegate)factory.getProxy();
    }

    public static interface ContainerDelegate {
        public boolean receiveAndExecute(Object var1, Session var2, MessageConsumer var3) throws JMSException;
    }
}

