/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ReaderNotOpenException;
import org.springframework.batch.item.file.FlatFileParseException;
import org.springframework.batch.item.file.LineCallbackHandler;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.file.separator.RecordSeparatorPolicy;
import org.springframework.batch.item.file.separator.SimpleRecordSeparatorPolicy;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatFileItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(FlatFileItemReader.class);
    public static final String DEFAULT_CHARSET = Charset.defaultCharset().name();
    private RecordSeparatorPolicy recordSeparatorPolicy = new SimpleRecordSeparatorPolicy();
    private Resource resource;
    private BufferedReader reader;
    private int lineCount = 0;
    private String[] comments = new String[]{"#"};
    private boolean noInput = false;
    private String encoding = DEFAULT_CHARSET;
    private LineMapper<T> lineMapper;
    private int linesToSkip = 0;
    private LineCallbackHandler skippedLinesCallback;
    private boolean strict = true;

    public FlatFileItemReader() {
        this.setName(ClassUtils.getShortName(FlatFileItemReader.class));
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSkippedLinesCallback(LineCallbackHandler skippedLinesCallback) {
        this.skippedLinesCallback = skippedLinesCallback;
    }

    public void setLinesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
    }

    public void setLineMapper(LineMapper<T> lineMapper) {
        this.lineMapper = lineMapper;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setComments(String[] comments) {
        this.comments = new String[comments.length];
        System.arraycopy(comments, 0, this.comments, 0, comments.length);
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setRecordSeparatorPolicy(RecordSeparatorPolicy recordSeparatorPolicy) {
        this.recordSeparatorPolicy = recordSeparatorPolicy;
    }

    @Override
    protected T doRead() throws Exception {
        String logicalLine;
        String line;
        if (this.noInput) {
            return null;
        }
        String record = line = this.readLine();
        if (line != null) {
            while (line != null && !this.recordSeparatorPolicy.isEndOfRecord(record)) {
                line = this.readLine();
                record = String.valueOf(this.recordSeparatorPolicy.preProcess(record)) + line;
            }
        }
        if ((logicalLine = this.recordSeparatorPolicy.postProcess(record)) == null) {
            return null;
        }
        try {
            return this.lineMapper.mapLine(logicalLine, this.lineCount);
        }
        catch (Exception ex) {
            logger.error((Object)("Parsing error at line: " + this.lineCount + " in resource=" + this.resource.getDescription() + ", input=[" + line + "]"), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLine() {
        if (this.reader == null) {
            throw new ReaderNotOpenException("Reader must be open before it can be read.");
        }
        String line = null;
        try {
            line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            ++this.lineCount;
            while (true) {
                if (!this.isComment(line)) {
                    return line;
                }
                line = this.reader.readLine();
                if (line == null) {
                    return null;
                }
                ++this.lineCount;
            }
        }
        catch (IOException e) {
            throw new FlatFileParseException("Unable to read from resource: [" + this.resource + "]", (Throwable)e, line, this.lineCount);
        }
    }

    private boolean isComment(String line) {
        String[] stringArray = this.comments;
        int n = this.comments.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (line.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void doClose() throws Exception {
        this.lineCount = 0;
        if (this.resource.exists()) {
            this.reader.close();
        }
    }

    @Override
    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Input resource must be set");
        Assert.notNull((Object)this.recordSeparatorPolicy, (String)"RecordSeparatorPolicy must be set");
        this.noInput = false;
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode): " + this.resource);
            }
            this.noInput = true;
            logger.warn((Object)("Input resource does not exist " + this.resource.getDescription()));
            return;
        }
        this.reader = new BufferedReader(new InputStreamReader(this.resource.getInputStream(), this.encoding));
        int i = 0;
        while (i < this.linesToSkip) {
            String line = this.readLine();
            if (this.skippedLinesCallback != null) {
                this.skippedLinesCallback.handleLine(line);
            }
            ++i;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.lineMapper, (String)"LineMapper is required");
    }
}

