/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultFieldSet
implements FieldSet {
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private NumberFormat numberFormat;
    private String[] tokens;
    private List<String> names;

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public DefaultFieldSet(String[] tokens) {
        this.dateFormat.setLenient(false);
        this.numberFormat = NumberFormat.getInstance(Locale.US);
        this.tokens = tokens == null ? null : (String[])tokens.clone();
    }

    public DefaultFieldSet(String[] tokens, String[] names) {
        this.dateFormat.setLenient(false);
        this.numberFormat = NumberFormat.getInstance(Locale.US);
        Assert.notNull((Object)tokens);
        Assert.notNull((Object)names);
        if (tokens.length != names.length) {
            throw new IllegalArgumentException("Field names must be same length as values: names=" + Arrays.asList(names) + ", values=" + Arrays.asList(tokens));
        }
        this.tokens = (String[])tokens.clone();
        this.names = Arrays.asList(names);
    }

    public String[] getNames() {
        if (this.names == null) {
            throw new IllegalStateException("Field names are not known");
        }
        return this.names.toArray(new String[this.names.size()]);
    }

    public boolean hasNames() {
        return this.names != null;
    }

    public String[] getValues() {
        return (String[])this.tokens.clone();
    }

    public String readString(int index) {
        return this.readAndTrim(index);
    }

    public String readString(String name) {
        return this.readString(this.indexOf(name));
    }

    public String readRawString(int index) {
        return this.tokens[index];
    }

    public String readRawString(String name) {
        return this.readRawString(this.indexOf(name));
    }

    public boolean readBoolean(int index) {
        return this.readBoolean(index, "true");
    }

    public boolean readBoolean(String name) {
        return this.readBoolean(this.indexOf(name));
    }

    public boolean readBoolean(int index, String trueValue) {
        Assert.notNull((Object)trueValue, (String)"'trueValue' cannot be null.");
        String value = this.readAndTrim(index);
        return trueValue.equals(value);
    }

    public boolean readBoolean(String name, String trueValue) {
        return this.readBoolean(this.indexOf(name), trueValue);
    }

    public char readChar(int index) {
        String value = this.readAndTrim(index);
        Assert.isTrue((value.length() == 1 ? 1 : 0) != 0, (String)("Cannot convert field value '" + value + "' to char."));
        return value.charAt(0);
    }

    public char readChar(String name) {
        return this.readChar(this.indexOf(name));
    }

    public byte readByte(int index) {
        return Byte.parseByte(this.readAndTrim(index));
    }

    public byte readByte(String name) {
        return this.readByte(this.indexOf(name));
    }

    public short readShort(int index) {
        return Short.parseShort(this.readAndTrim(index));
    }

    public short readShort(String name) {
        return this.readShort(this.indexOf(name));
    }

    public int readInt(int index) {
        return this.parseNumber(this.readAndTrim(index)).intValue();
    }

    public int readInt(String name) {
        return this.readInt(this.indexOf(name));
    }

    public int readInt(int index, int defaultValue) {
        String value = this.readAndTrim(index);
        return StringUtils.hasLength((String)value) ? Integer.parseInt(value) : defaultValue;
    }

    public int readInt(String name, int defaultValue) {
        return this.readInt(this.indexOf(name), defaultValue);
    }

    public long readLong(int index) {
        return this.parseNumber(this.readAndTrim(index)).longValue();
    }

    public long readLong(String name) {
        return this.readLong(this.indexOf(name));
    }

    public long readLong(int index, long defaultValue) {
        String value = this.readAndTrim(index);
        return StringUtils.hasLength((String)value) ? Long.parseLong(value) : defaultValue;
    }

    public long readLong(String name, long defaultValue) {
        return this.readLong(this.indexOf(name), defaultValue);
    }

    public float readFloat(int index) {
        return this.parseNumber(this.readAndTrim(index)).floatValue();
    }

    public float readFloat(String name) {
        return this.readFloat(this.indexOf(name));
    }

    public double readDouble(int index) {
        return this.parseNumber(this.readAndTrim(index)).doubleValue();
    }

    public double readDouble(String name) {
        return this.readDouble(this.indexOf(name));
    }

    public BigDecimal readBigDecimal(int index) {
        return this.readBigDecimal(index, null);
    }

    public BigDecimal readBigDecimal(String name) {
        return this.readBigDecimal(name, null);
    }

    public BigDecimal readBigDecimal(int index, BigDecimal defaultValue) {
        String candidate = this.readAndTrim(index);
        try {
            return StringUtils.hasText((String)candidate) ? new BigDecimal(candidate) : defaultValue;
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Unparseable number: " + candidate);
        }
    }

    public BigDecimal readBigDecimal(String name, BigDecimal defaultValue) {
        try {
            return this.readBigDecimal(this.indexOf(name), defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(e.getMessage()) + ", name: [" + name + "]");
        }
    }

    public Date readDate(int index) {
        return this.parseDate(this.readAndTrim(index), this.dateFormat);
    }

    public Date readDate(String name) {
        try {
            return this.readDate(this.indexOf(name));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(e.getMessage()) + ", name: [" + name + "]");
        }
    }

    public Date readDate(int index, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setLenient(false);
        return this.parseDate(this.readAndTrim(index), sdf);
    }

    public Date readDate(String name, String pattern) {
        try {
            return this.readDate(this.indexOf(name), pattern);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(e.getMessage()) + ", name: [" + name + "]");
        }
    }

    public int getFieldCount() {
        return this.tokens.length;
    }

    protected String readAndTrim(int index) {
        String value = this.tokens[index];
        if (value != null) {
            return value.trim();
        }
        return null;
    }

    protected int indexOf(String name) {
        if (this.names == null) {
            throw new IllegalArgumentException("Cannot access columns by name without meta data");
        }
        int index = this.names.indexOf(name);
        if (index >= 0) {
            return index;
        }
        throw new IllegalArgumentException("Cannot access column [" + name + "] from " + this.names);
    }

    public String toString() {
        if (this.names != null) {
            return this.getProperties().toString();
        }
        return this.tokens == null ? "" : Arrays.asList(this.tokens).toString();
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultFieldSet) {
            DefaultFieldSet fs = (DefaultFieldSet)object;
            if (this.tokens == null) {
                return fs.tokens == null;
            }
            return Arrays.equals(this.tokens, fs.tokens);
        }
        return false;
    }

    public int hashCode() {
        if (this.tokens == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < this.tokens.length) {
            result = 31 * result + (this.tokens[i] == null ? 0 : this.tokens[i].hashCode());
            ++i;
        }
        return result;
    }

    public Properties getProperties() {
        if (this.names == null) {
            throw new IllegalStateException("Cannot create properties without meta data");
        }
        Properties props = new Properties();
        int i = 0;
        while (i < this.tokens.length) {
            String value = this.readAndTrim(i);
            if (value != null) {
                props.setProperty(this.names.get(i), value);
            }
            ++i;
        }
        return props;
    }

    private Number parseNumber(String candidate) {
        try {
            return this.numberFormat.parse(candidate);
        }
        catch (ParseException parseException) {
            throw new NumberFormatException("Unparseable number: " + candidate);
        }
    }

    private Date parseDate(String readAndTrim, DateFormat dateFormat) {
        try {
            return dateFormat.parse(readAndTrim);
        }
        catch (ParseException e) {
            String pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new IllegalArgumentException(String.valueOf(e.getMessage()) + ", format: [" + pattern + "]");
        }
    }
}

