/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.batch.repeat.RepeatListener;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.exception.DefaultExceptionHandler;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.policy.DefaultResultCompletionPolicy;
import org.springframework.batch.repeat.support.RepeatInternalState;
import org.springframework.batch.repeat.support.RepeatInternalStateSupport;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.util.Assert;

public class RepeatTemplate
implements RepeatOperations {
    protected Log logger = LogFactory.getLog(this.getClass());
    private RepeatListener[] listeners = new RepeatListener[0];
    private CompletionPolicy completionPolicy = new DefaultResultCompletionPolicy();
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();

    public void setListeners(RepeatListener[] listeners) {
        this.listeners = listeners;
    }

    public void registerListener(RepeatListener listener) {
        ArrayList<RepeatListener> list = new ArrayList<RepeatListener>((Collection)Arrays.asList(this.listeners));
        list.add(listener);
        this.listeners = list.toArray(new RepeatListener[list.size()]);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setCompletionPolicy(CompletionPolicy terminationPolicy) {
        Assert.notNull((Object)terminationPolicy);
        this.completionPolicy = terminationPolicy;
    }

    public RepeatStatus iterate(RepeatCallback callback) {
        RepeatContext outer = RepeatSynchronizationManager.getContext();
        RepeatStatus result = RepeatStatus.CONTINUABLE;
        try {
            result = this.executeInternal(callback);
        }
        finally {
            RepeatSynchronizationManager.clear();
            if (outer != null) {
                RepeatSynchronizationManager.register(outer);
            }
        }
        return result;
    }

    private RepeatStatus executeInternal(RepeatCallback callback) {
        RepeatStatus result;
        RepeatContext context;
        block29: {
            Throwable throwable3;
            context = this.start();
            boolean running = !this.isMarkedComplete(context);
            int i = 0;
            while (i < this.listeners.length) {
                RepeatListener interceptor = this.listeners[i];
                interceptor.open(context);
                boolean bl = running = running && !this.isMarkedComplete(context);
                if (!running) break;
                ++i;
            }
            result = RepeatStatus.CONTINUABLE;
            RepeatInternalState state = this.createInternalState(context);
            Collection<Throwable> throwables = state.getThrowables();
            try {
                while (running) {
                    int i2 = 0;
                    while (i2 < this.listeners.length) {
                        RepeatListener interceptor = this.listeners[i2];
                        interceptor.before(context);
                        running = running && !this.isMarkedComplete(context);
                        ++i2;
                    }
                    if (!running) continue;
                    this.logger.debug((Object)("Repeat operation about to start at count=" + context.getStartedCount()));
                    try {
                        result = this.getNextResult(context, callback, state);
                        this.executeAfterInterceptors(context, result);
                    }
                    catch (Throwable throwable2) {
                        Throwable unwrappedThrowable = RepeatTemplate.unwrapIfRethrown(throwable2);
                        try {
                            int i3 = this.listeners.length;
                            while (i3-- > 0) {
                                RepeatListener interceptor = this.listeners[i3];
                                interceptor.onError(context, unwrappedThrowable);
                                this.logger.debug((Object)("Exception intercepted (" + (i3 + 1) + " of " + this.listeners.length + ")"), unwrappedThrowable);
                            }
                            this.exceptionHandler.handleException(context, unwrappedThrowable);
                        }
                        catch (Throwable handled) {
                            throwables.add(handled);
                        }
                    }
                    if (!this.isComplete(context, result) && !this.isMarkedComplete(context) && throwables.isEmpty()) continue;
                    running = false;
                }
                result = result.and(this.waitForResults(state));
                state = null;
            }
            finally {
                try {
                    if (!throwables.isEmpty()) {
                        RepeatTemplate.rethrow(throwables.iterator().next());
                    }
                    break block29;
                }
                catch (Throwable throwable3) {
                    try {
                        int i4 = this.listeners.length;
                        while (i4-- > 0) {
                            RepeatListener interceptor = this.listeners[i4];
                            interceptor.close(context);
                        }
                    }
                    finally {
                        context.close();
                    }
                }
            }
            throw throwable3;
        }
        try {
            int i = this.listeners.length;
            while (i-- > 0) {
                RepeatListener interceptor = this.listeners[i];
                interceptor.close(context);
            }
        }
        finally {
            context.close();
        }
        return result;
    }

    private static void rethrow(Throwable throwable) throws RuntimeException {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RepeatException("Exception in batch process", throwable);
    }

    private static Throwable unwrapIfRethrown(Throwable throwable) {
        if (throwable instanceof RepeatException) {
            return throwable.getCause();
        }
        return throwable;
    }

    protected RepeatInternalState createInternalState(RepeatContext context) {
        return new RepeatInternalStateSupport();
    }

    protected RepeatStatus getNextResult(RepeatContext context, RepeatCallback callback, RepeatInternalState state) throws Throwable {
        this.update(context);
        return callback.doInIteration(context);
    }

    protected boolean waitForResults(RepeatInternalState state) {
        return true;
    }

    protected final boolean canContinue(RepeatStatus value) {
        return value.isContinuable();
    }

    private boolean isMarkedComplete(RepeatContext context) {
        boolean complete = context.isCompleteOnly();
        if (context.getParent() != null) {
            boolean bl = complete = complete || this.isMarkedComplete(context.getParent());
        }
        if (complete) {
            this.logger.debug((Object)"Repeat is complete according to context alone.");
        }
        return complete;
    }

    protected void executeAfterInterceptors(RepeatContext context, RepeatStatus value) {
        if (value != null && value.isContinuable()) {
            int i = this.listeners.length;
            while (i-- > 0) {
                RepeatListener interceptor = this.listeners[i];
                interceptor.after(context, value);
            }
        }
    }

    protected boolean isComplete(RepeatContext context, RepeatStatus result) {
        boolean complete = this.completionPolicy.isComplete(context, result);
        if (complete) {
            this.logger.debug((Object)"Repeat is complete according to policy and result value.");
        }
        return complete;
    }

    protected boolean isComplete(RepeatContext context) {
        boolean complete = this.completionPolicy.isComplete(context);
        if (complete) {
            this.logger.debug((Object)"Repeat is complete according to policy alone not including result.");
        }
        return complete;
    }

    protected RepeatContext start() {
        RepeatContext parent = RepeatSynchronizationManager.getContext();
        RepeatContext context = this.completionPolicy.start(parent);
        RepeatSynchronizationManager.register(context);
        this.logger.debug((Object)"Starting repeat context.");
        return context;
    }

    protected void update(RepeatContext context) {
        this.completionPolicy.update(context);
    }
}

