/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternMatcher<S> {
    private Map<String, S> map = new HashMap<String, S>();
    private List<String> sorted = new ArrayList<String>();

    public PatternMatcher(Map<String, S> map) {
        this.map = map;
        this.sorted = new ArrayList<String>((Collection)map.keySet());
        Collections.sort(this.sorted, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String s1 = o1;
                String s2 = o2;
                return s2.compareTo(s1);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public static boolean match(String pattern, String str) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = pattern.contains("*");
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (ch != '?' && ch != strArr[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl25
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
lbl25:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl26:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl38
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl38:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl39:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl79
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block22: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (ch == '?' || ch == strArr[strIdxStart + i + j]) {
                            ++j;
                            continue;
                        }
                        break block22;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl79:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl80:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public S match(String line) {
        S value = null;
        Assert.notNull((Object)line, (String)"A non-null key must be provided to match against.");
        for (String key : this.sorted) {
            if (!PatternMatcher.match(key, line)) continue;
            value = this.map.get(key);
            break;
        }
        if (value == null) {
            throw new IllegalStateException("Could not find a matching pattern for key=[" + line + "]");
        }
        return value;
    }
}

