/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.mapping;

import org.springframework.batch.item.file.FlatFileParseException;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLineMapper<T>
implements LineMapper<T>,
InitializingBean {
    private LineTokenizer tokenizer;
    private FieldSetMapper<T> fieldSetMapper;

    @Override
    public T mapLine(String line, int lineNumber) throws Exception {
        try {
            return this.fieldSetMapper.mapFieldSet(this.tokenizer.tokenize(line));
        }
        catch (Exception ex) {
            throw new FlatFileParseException("Parsing error at line: " + lineNumber + ", input=[" + line + "]", (Throwable)ex, line, lineNumber);
        }
    }

    public void setLineTokenizer(LineTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public void setFieldSetMapper(FieldSetMapper<T> fieldSetMapper) {
        this.fieldSetMapper = fieldSetMapper;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.tokenizer, (String)"The LineTokenizer must be set");
        Assert.notNull(this.fieldSetMapper, (String)"The FieldSetMapper must be set");
    }
}

