/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.springframework.batch.item.file.BufferedReaderFactory;
import org.springframework.core.io.Resource;

public class SimpleBinaryBufferedReaderFactory
implements BufferedReaderFactory {
    private static final String DEFAULT_LINE_ENDING = "\n";
    private String lineEnding = "\n";

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    public BufferedReader create(Resource resource, String encoding) throws UnsupportedEncodingException, IOException {
        return new BinaryBufferedReader(new InputStreamReader(resource.getInputStream(), encoding), this.lineEnding);
    }

    private final class BinaryBufferedReader
    extends BufferedReader {
        private final String ending;

        private BinaryBufferedReader(Reader in, String ending) {
            super(in);
            this.ending = ending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String readLine() throws IOException {
            StringBuilder buffer = null;
            Object object = this.lock;
            synchronized (object) {
                int next = this.read();
                if (next == -1) {
                    return null;
                }
                buffer = new StringBuilder();
                StringBuilder candidateEnding = new StringBuilder();
                while (!this.isEndOfLine(buffer, candidateEnding, next)) {
                    next = this.read();
                }
                buffer.append((CharSequence)candidateEnding);
            }
            if (buffer != null && buffer.length() > 0) {
                return buffer.toString();
            }
            return null;
        }

        private boolean isEndOfLine(StringBuilder buffer, StringBuilder candidate, int next) {
            if (next == -1) {
                return true;
            }
            char c = (char)next;
            if (this.ending.charAt(0) == c || candidate.length() > 0) {
                candidate.append(c);
            }
            if (candidate.length() == 0) {
                buffer.append(c);
                return false;
            }
            boolean end = this.ending.equals(candidate.toString());
            if (end) {
                candidate.delete(0, candidate.length());
            } else if (candidate.length() >= this.ending.length()) {
                buffer.append((CharSequence)candidate);
                candidate.delete(0, candidate.length());
            }
            return end;
        }
    }
}

