/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private List<ItemWriter<? super T>> delegates;

    @Override
    public void write(List<? extends T> item) throws Exception {
        for (ItemWriter<? extends T> itemWriter : this.delegates) {
            itemWriter.write(item);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegates, (String)"The 'delgates' may not be null");
        Assert.notEmpty(this.delegates, (String)"The 'delgates' may not be empty");
    }

    public void setDelegates(List<ItemWriter<? super T>> delegates) {
        this.delegates = delegates;
    }
}

