/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.common;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.item.ItemWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfiniteLoopWriter
extends StepExecutionListenerSupport
implements ItemWriter<Object> {
    private StepExecution stepExecution;
    private int count = 0;
    private static final Log logger = LogFactory.getLog(InfiniteLoopWriter.class);

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends Object> items) throws Exception {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Job interrupted.");
        }
        this.stepExecution.setWriteCount(++this.count);
        logger.info((Object)("Executing infinite loop, at count=" + this.count));
    }
}

