/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.common;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingItemWriter<T>
extends JdbcDaoSupport
implements StepExecutionListener,
ItemWriter<T> {
    public static final String NEW = "N";
    public static final String DONE = "Y";
    public static final Object WORKING = "W";
    private DataFieldMaxValueIncrementer incrementer;
    private StepExecution stepExecution;
    private LobHandler lobHandler = new DefaultLobHandler();

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    protected void initDao() throws Exception {
        super.initDao();
        Assert.notNull((Object)this.incrementer, (String)("DataFieldMaxValueIncrementer is required - set the incrementer property in the " + ClassUtils.getShortName(StagingItemWriter.class)));
    }

    public void setIncrementer(DataFieldMaxValueIncrementer incrementer) {
        this.incrementer = incrementer;
    }

    public void write(final List<? extends T> items) {
        final ListIterator<? extends T> itemIterator = items.listIterator();
        this.getJdbcTemplate().batchUpdate("INSERT into BATCH_STAGING (ID, JOB_ID, VALUE, PROCESSED) values (?,?,?,?)", new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return items.size();
            }

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                long id = StagingItemWriter.this.incrementer.nextLongValue();
                long jobId = StagingItemWriter.this.stepExecution.getJobExecution().getJobId();
                Assert.state((itemIterator.nextIndex() == i ? 1 : 0) != 0, (String)"Item ordering must be preserved in batch sql update");
                byte[] blob = SerializationUtils.serialize((Serializable)((Serializable)itemIterator.next()));
                ps.setLong(1, id);
                ps.setLong(2, jobId);
                StagingItemWriter.this.lobHandler.getLobCreator().setBlobAsBytes(ps, 3, blob);
                ps.setString(4, StagingItemWriter.NEW);
            }
        });
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public ExitStatus onErrorInStep(StepExecution stepExecution, Throwable e) {
        return null;
    }
}

