/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.domain.football.internal;

import java.util.List;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.sample.domain.football.Game;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcGameDao
extends SimpleJdbcDaoSupport
implements ItemWriter<Game> {
    private SimpleJdbcInsert insertGame;

    protected void initDao() throws Exception {
        super.initDao();
        this.insertGame = new SimpleJdbcInsert(this.getDataSource()).withTableName("GAMES").usingColumns(new String[]{"player_id", "year_no", "team", "week", "opponent", " completes", "attempts", "passing_yards", "passing_td", "interceptions", "rushes", "rush_yards", "receptions", "receptions_yards", "total_td"});
    }

    public void write(List<? extends Game> games) {
        for (Game game : games) {
            MapSqlParameterSource values = new MapSqlParameterSource().addValue("player_id", (Object)game.getId()).addValue("year_no", (Object)game.getYear()).addValue("team", (Object)game.getTeam()).addValue("week", (Object)game.getWeek()).addValue("opponent", (Object)game.getOpponent()).addValue("completes", (Object)game.getCompletes()).addValue("attempts", (Object)game.getAttempts()).addValue("passing_yards", (Object)game.getPassingYards()).addValue("passing_td", (Object)game.getPassingTd()).addValue("interceptions", (Object)game.getInterceptions()).addValue("rushes", (Object)game.getRushes()).addValue("rush_yards", (Object)game.getRushYards()).addValue("receptions", (Object)game.getReceptions()).addValue("receptions_yards", (Object)game.getReceptionYards()).addValue("total_td", (Object)game.getTotalTd());
            this.insertGame.execute((SqlParameterSource)values);
        }
    }

    public void clear() throws ClearFailedException {
    }

    public void flush() throws FlushFailedException {
    }
}

